/*
  DJI Naza (v1, v1 Lite, V2) data decoder library from Pawelsky (c) 20141109
  Refer to naza_decoder_wiring.jpg diagram for proper connection
  http://www.rcgroups.com/forums/showthread.php?t=1995704

  Ported to mbed by Garfield38 20141128

  Not for commercial use
  
*/

#ifndef __NAZA_DECODER_LIB_H__
#define __NAZA_DECODER_LIB_H__

#include "stdint.h"

#define NAZA_MESSAGE_NONE    0x00
#define NAZA_MESSAGE_GPS     0x10
#define NAZA_MESSAGE_COMPASS 0x20

/** Naza Decoder Class(es)
 */
class NazaDecoderLib
{
public:
    typedef enum { NO_FIX = 0, FIX_2D = 2, FIX_3D = 3, FIX_DGPS = 4 } fixType_t;

    /** Create a NazaDecoderLib object receiving serial data byte
    */
    NazaDecoderLib();

    uint8_t decode(uint8_t input);
    void getDebug(RawSerial &s, char* buf);
    /** Return the latitude GPS position
    */
    double getLat();
    /** Return the longitude GPS position
    */
    double getLon();
    /** Return the altitude GPS elevation
    */
    double getGpsAlt();
    /** Return the GPS speed
    */
    double getSpeed();
    /** Return the GPS fix mode NO_FIX = 0, 2D = 2, 3D = 3, DGPS = 4
    */
    fixType_t getFixType();
    /** Return the GPS number of satellites
    */
    uint8_t getNumSat();
    /** heading (not tilt compensated in degrees)
    */
    double getHeadingNc();
    /** course over ground
    */
    double getCog();
    /** vertical speed indicator (from GPS) in m/s (a.k.a. climb speed)
    */
    double getGpsVsi();
    /** horizontal dilution of precision
    */
    double getHdop();
    /** vertical dilution of precision
    */
    double getVdop();
    /** Return the GPS Year time
    */
    uint8_t getYear();
    /** Return the GPS Month time
    */
    uint8_t getMonth();
    /** Return the GPS Day time
    */
    uint8_t getDay();
    /** Return the GPS Hour time
    * Note that for time between 16:00 and 23:59 the hour returned from GPS module is actually 00:00 - 7:59.
    */
    uint8_t getHour();
    /** Return the GPS Minute time
    */
    uint8_t getMinute();
    /** Return the GPS Second time
    */
    uint8_t getSecond();

private:
    int gpsPayload[58];
    int seq;
    int syncError;
    int cnt;
    int msgId;
    int msgLen;
    uint8_t cs1; // checksum #1
    uint8_t cs2; // checksum #2
    int16_t magXMin;
    int16_t magXMax;
    int16_t magYMin;
    int16_t magYMax;

    double lon;     // longitude in degree decimal
    double lat;     // latitude in degree decimal
    double gpsAlt;  // altitude in m (from GPS)
    double spd;     // speed in m/s
    fixType_t fix;   // fix type
    uint8_t sat;     // number of satellites
    double headingNc;// heading (not tilt compensated in degrees)
    double cog;     // course over ground
    double gpsVsi;  // vertical speed indicator (from GPS) in m/s (a.k.a. climb speed)
    double hdop;    // horizontal dilution of precision
    double vdop;    // vertical dilution of precision
    uint8_t year;
    uint8_t month;
    uint8_t day;
    uint8_t hour;
    uint8_t minute;
    uint8_t second;

    int32_t  decodeLong(uint8_t idx, uint8_t mask);
    int16_t  decodeShort(uint8_t idx, uint8_t mask);
    void     updateCS(uint8_t input);

};

extern NazaDecoderLib NazaDecoder;

#endif // __NAZA_DECODER_LIB_H__
