/*
 * CSerial.cpp
 *
 *  Created on: 18 Mar 2016
 *      Author: mike
 */

#include "mbed.h"
#include "base.h"

#define MAX_STRLEN	64

static time_t seconds;
extern Serial pc;
extern ROTATION rotn;

/*
 * Handles the interface to the user via Virtual Comm Port uart class (pc)
 */
char handleSerial(void)
{
    char buffer[MAX_STRLEN];
	char cmd = '@';

	if (pc.readable())		//	Uncomment if using USBSerial class
	{

		cmd = pc.getc();
		if (cmd == '.')
		{
			pc.printf("Enter your command: ");
			cmd = pc.getc();
			pc.printf("%c\r\n", cmd);

			//	Between A and z
			if ((cmd >= '0') && (cmd <= 'z'))
			{

				switch(cmd)
				{

					case 'd'	:	//  Get the current time
					case 'D'	:
						seconds = time(NULL);
						strftime(buffer, MAX_STRLEN, "%A %d %B:%Y %H:%M:%S\r\n", localtime(&seconds));
						pc.printf("Time %s", buffer);
						break;

					case 'G'	:	//	Go (hand control over to the remote server
					case 'g'	:
						pc.printf("Handing control over to the Server\r\n");
						break;

					case 'r'	:	//  Initial Set up
					case 'R'	:
						RotateCmd(&rotn);
						break;

					case 'S'	:	//  Initial Set up
					case 's'	:
						setMcTime();
						break;

				}
			}
		}
		else
			pc.printf("\r\nType  .  to enter Command Mode\r\n");
		pc.printf("\r\n");
	}


	return(cmd);
}


int	echogets(char* str)
{
	char c=0;
	int i = 0;

	while ((c != 0x0d) && (c != 0x0a))
	{
		c = pc.getc();
		pc.putc(c);			//  Echo for user
		if (i < MAX_STRLEN)		//	Max string length
		{
			str[i++] = c;
		}
	}
	return (i);					//	Return number of chars read

}


time_t setMcTime(void)
{
    char buffer[MAX_STRLEN];
    struct tm *t = {0};
    time_t systime;
    int bytecount;

	systime = time(NULL);
	t = localtime(&systime);

	pc.printf("\r\nSetting the system time...\r\n");
	pc.printf("Enter the current year (2 digits) [%d]: ", t->tm_year -100 );
	bytecount=echogets(buffer);
	if (bytecount > 1)
		t->tm_year = strtol(buffer, NULL, 10) + 100;

	pc.printf("\r\nEnter the current month (1 to 12) [%d]: ", t->tm_mon +1);
	bytecount=echogets(buffer);
	if (bytecount > 1)
		t->tm_mon = strtol(buffer, NULL, 10) -1;

	pc.printf("\r\nEnter the day of month (1 to 31) [%d]: ", t->tm_mday);
	bytecount=echogets(buffer);
	if (bytecount > 1)
		t->tm_mday = strtol(buffer, NULL, 10);

	pc.printf("\r\nEnter the current hour (00 to 23) [%d]: ", t->tm_hour);
	bytecount=echogets(buffer);
	if (bytecount > 1)
		t->tm_hour = strtol(buffer, NULL, 10);

	pc.printf("\r\nEnter the current minute (0 to 59) [%d]: ", t->tm_min);
	bytecount=echogets(buffer);
	if (bytecount > 1)
		t->tm_min = strtol(buffer, NULL, 10);

	systime = mktime(t);

	if (systime >=0)
	{
		strftime(buffer, MAX_STRLEN, "%A %d %B:%Y %H:%M:%S\r\n", localtime(&systime));
		pc.printf("\r\nSystem Time set to  %s\r\n", buffer);
		set_time(systime);
	}
	else
		pc.printf("Not a valid date and time, system time has NOT been updated\r\n");

	return (systime);

}


void	RotateCmd(ROTATION * protn)
{
    char buffer[MAX_STRLEN];
    int bytecount;

	pc.printf("Enter the X Angle: ");
	bytecount=echogets(buffer);
	if (bytecount > 1)
		protn->xAngle = strtol(buffer, NULL, 10);

	pc.printf("\r\nEnter the Y Angle: ");
	bytecount=echogets(buffer);
	if (bytecount > 1)
		protn->yAngle = strtol(buffer, NULL, 10);
	pc.printf("\r\n(X,Y) = %3.1f,%3.1f\r\n", rotn.xAngle, rotn.yAngle);
}
