/*
 * CoreISR.cpp
 *
 *  Created on: 12 Mar 2016
 *      Author: mike
 */
#include "mbed.h"
#include "CGimbal.h"
#include "base.h"


extern int mgTick;
extern CGimbal * pGimbal;
extern DigitalIn	xHome;
extern DigitalIn	yHome;
extern Serial pc;



/*
 *	Core Stepper Timer, called every 20 us
 */
void Pulse()
{

	mgTick++;

	//	If m_TickCount (every 20us) has incremented to the defined step interval (1000us) then action may need to be taken
	if (pGimbal->m_TickCount > pGimbal->m_StepInterval)
	{
		if (pGimbal->m_TickCount & 0x01)	// First (rising) edge of the pulse
		{
			if (pGimbal->m_xPulses)			// Still need to move along x?
			{
				if (xHome)					//	Are we clear of the x Limit switch?
				{
					pGimbal->m_pXStepPin->write(1);
				}
			}
			if (pGimbal->m_yPulses)			// Still need to move along y?
			{
				if (yHome)					//	Are we clear of the y Limit switch?
				{
					pGimbal->m_pYStepPin->write(1);
				}
			}
			pGimbal->m_TickCount++;
		}
		else
		{	//	Second (falling) edge of the pulse
			if (pGimbal->m_xPulses)
			{
				//	This x pulse has been completed
				pGimbal->m_pXStepPin->write(0);
				pGimbal->m_xPulses --;
			}
			if (pGimbal->m_yPulses)
			{
				//	This y pulse has been completed
				pGimbal->m_pYStepPin->write(0);
				pGimbal->m_yPulses --;
			}
			//  Regardless of whether only x or only y falling edge was actioned, the window is now closed
			pGimbal->m_TickCount=0;
		}
	}
	else
	{
		pGimbal->m_TickCount++;
	}

}

