#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPServer.h"

DigitalOut led1(LED1, "led1");

LocalFileSystem fs("webfs");

EthernetNetIf eth(
    IpAddr(192,168,1,22),
    IpAddr(255,255,255,0),
    IpAddr(192,168,0,1),
    IpAddr(192,168,0,1)
);
HTTPServer svr;

int main()
{

    printf("Setting up...\n");
    EthernetErr ethErr = eth.setup();
    if(ethErr) {
        printf("Error %d in setup.\n", ethErr);
        return -1;
    }
    printf("Setup OK\n");

    FSHandler::mount("/webfs", "/files"); //Mount /webfs path on /files web path
    FSHandler::mount("/webfs", "/"); //Mount /webfs path on web root path

    svr.addHandler<FSHandler>("/files");
    svr.addHandler<FSHandler>("/"); //Default handler
    //Example : Access to mbed.htm : http://a.b.c.d/mbed.htm or http://a.b.c.d/files/mbed.htm

    svr.bind(80);

    printf("Listening...\n");

    led1 = 1;
    //Listen indefinitely
    while(true) {
        Net::poll();

    }

    return 0;

}
