#include "USBHostMouse.h"
#include "HMC6352.h"

#define PFLAG_ON 0
#define PFLAG_OFF 1
#define PFLAG_CALIB 2
#define PTURN_SPEED (0.5)

float PTURN_RIGHT = 0;

extern Serial pc(USBTX, USBRX);

// updates xy position if on, does nothing if off
extern char PFlag = PFLAG_ON;

// whenever a turn is complete, this should store 
// the degrees facing (0, 90, 180, 270) in system
extern int t_position = 0;

// variables to keep track of coordinate position
float x_position = 0;
float y_position = 0;

// variables to keep track of movement during turning
float pturn_x = 0;
float pturn_y = 0;

/* mouse event handler */
void onMouseEvent(uint8_t buttons, int8_t x_mickey, int8_t y_mickey, int8_t z) {
    
    // calculate new position 
    if(PFlag == PFLAG_ON) {
        
        // mouse movements are in mickeys. 1 mickey = ~230 DPI = ~1/230th of an inch
        float temp = y_mickey / 232.6;
        
        // determine direction we are facing and add to that direction
        if(t_position == 0)
            y_position += temp;
        else if(t_position == 90)
            x_position += temp;
        else if(t_position == 180)
            y_position -= temp;
        else
            x_position -= temp;
    } else if(PFlag == PFLAG_CALIB) {    
        PTURN_RIGHT += x_mickey / 232.6;
    } else {
        pturn_x += x_mickey / 232.6;
        pturn_y += y_mickey / 232.6;
    }
}

// intialize x and y variables for turning
void turnInit() {
    pturn_x = 0;
    pturn_y = 0;
}
    
/* positioning system thread function */
void PositionSystemMain(void const *) {
    
    USBHostMouse mouse;
    
    while(1) {
        // try to connect a USB mouse
        while(!mouse.connect())
            Thread::wait(500);
    
        // when connected, attach handler called on mouse event
        mouse.attachEvent(onMouseEvent);
        
        // wait until the mouse is disconnected
        while(mouse.connected())
            Thread::wait(500);
    }
}