#include "mbed.h"
#include "RobotControl.h"
#include "rtos.h"
 
#define ENTERCALIB 0x43
#define EXITCALIB 0x45

DigitalOut led3(LED3);
DigitalOut led4(LED4);
DigitalOut rst1(p12);

Serial xbee1(p13, p14);
 
InterruptIn sw(p30);
 
void StopISR()
{
    rightMotorPWM = 0;
    leftMotorPWM = 0;
    exit(1);
}
 
int main() {
    
    //Emergency stop mechanism
    sw.rise(&StopISR);
    
    // start positioning system
    Thread position(PositionSystemMain, NULL, osPriorityNormal, 256 * 4);
    wait(3); // wait for the mouse sensor to boot up
    
    // calibrate 90 degree turns
    turnCalibrate();
    
    // PTURN_RIGHT is the measured x value for a 90 degree turn
    pc.printf("PTURN_RIGHT: %f\n\r", PTURN_RIGHT); 
    wait(1);
    
    // try a 90 degree turn with the measured PTURN_RIGHT value
    turnRight(90);
}