#include "mbed.h"
#include "WIZnetInterface.h"

unsigned char MAC_Addr[6] = {0x00,0x08,0xDC,0x12,0x07,0x07};

char* Public_Key = "0lJg1p2RXrSRqvODNmQj";
char* Private_Key = "D6XGDjbZPdHRYABzqmVl";
char* ServerIP = "192.168.44.70";

Serial pc(USBTX, USBRX);
SPI spi(PTD2,PTD3,PTD1);
WIZnetInterface ethernet(&spi,PTD0,PTA20);
AnalogIn temp(PTC1);


int main()
{
    //Set serial port baudrate speed: 115200
    pc.baud(115200);
    pc.printf("Start\r\n");
    
    char count;


    while(1) {
        int ret = ethernet.init(MAC_Addr);
        
        if (!ret) {
            pc.printf("Initialized, MAC: %s\r\n", ethernet.getMACAddress());
            ret = ethernet.connect();
            if (!ret) {
                pc.printf("IP: %s, MASK: %s, GW: %s\r\n",
                          ethernet.getIPAddress(), ethernet.getNetworkMask(), ethernet.getGateway());
            } else {
                pc.printf("Error ethernet.connect() - ret = %d\r\n", ret);
                exit(0);
            }
        } else {
            pc.printf("Error ethernet.init() - ret = %d\r\n", ret);
            exit(0);
        }
        
    count = 0;    
    
    TCPSocketConnection sock;
    sock.connect(ServerIP, 8080);
    if(sock.is_connected())
        printf("Socket Connected\n\r");
    else
        printf("Socket NoT Connected\n\r");
    
    char buffer[300];
    int ret_t;
    
    
    for (count=0;count<10;count++){
        char http_cmd[256]; 
        
        sprintf(http_cmd,"GET /input/%s?private_key=%s&var1=%d HTTP/1.0\n\n",Public_Key,Private_Key,count);
        sock.send_all(http_cmd, sizeof(http_cmd)-1);
        
        while (true) {
            ret_t = sock.receive(buffer, sizeof(buffer)-1);
            if (ret_t <= 0)
                break;
            buffer[ret_t] = '\0';
            printf("Received %d chars from server:\n%s\n", ret_t, buffer);
        }
    }
    sock.close();
    
    ethernet.disconnect();
    printf("Socket Closed");
    
    while(1) {}
}}
