#include "mbed.h"
#include "WIZnetInterface.h"

#define USE_DHCP    1

#define LOOPBACKPORT    5000

const char * IP_Addr    = "192.168.1.20";
const char * IP_Subnet  = "255.255.255.0";
const char * IP_Gateway = "192.168.1.1";
unsigned char MAC_Addr[6] = {0x00,0x08,0xDC,0x12,0x07,0x07};

DigitalOut myled1(LED1);
Serial pc(USBTX, USBRX);

//#ifdef TARGET_LPC11U68
SPI spi(PTD2,PTD3,PTD1);
WIZnetInterface ethernet(&spi,PTD0,PTA20);
//#endif

int main()
{
    
    uint8_t mac[6];
    
    // set these to match the mac address on the Arduino Ethernet Shield
    mac[0] = 0x90; mac[1] = 0xa2; mac[2] = 0xda; 
    mac[3] = 0x0f; mac[4] = 0x0e; mac[5] = 0x07;  // 90:a2:da:0f:0e:63
    
    
    
    //Set serial port baudrate speed: 115200
    pc.baud(115200);
    pc.printf("Started\r\n");

    //mbed_mac_address((char *)MAC_Addr); //Use mbed mac addres

    pc.printf("Start\r\n");

    char buffer[256];

    while(1) {
#if USE_DHCP
        int ret = ethernet.init(mac);
#else
        int ret = ethernet.init(MAC_Addr,IP_Addr,IP_Subnet,IP_Gateway);
#endif

        if (!ret) {
            pc.printf("Initialized, MAC: %s\r\n", ethernet.getMACAddress());
            ret = ethernet.connect();
            if (!ret) {
                pc.printf("IP: %s, MASK: %s, GW: %s\r\n",
                          ethernet.getIPAddress(), ethernet.getNetworkMask(), ethernet.getGateway());
            } else {
                pc.printf("Error ethernet.connect() - ret = %d\r\n", ret);
                exit(0);
            }
        } else {
            pc.printf("Error ethernet.init() - ret = %d\r\n", ret);
            exit(0);
        }
        while(1);
        TCPSocketServer server;
        server.bind(LOOPBACKPORT);
        server.listen();

        while (1) {
            pc.printf("\nWait for new connection...\r\n");
            TCPSocketConnection client;
            server.accept(client);
            client.set_blocking(false, 0); // Timeout=0.
            pc.printf("Connection from: %s\r\n", client.get_address());
            while (client.is_connected() == true) {
                int n = client.receive(buffer, sizeof(buffer));
                if(n > 0)
                    client.send_all(buffer, n);
                if(client.is_fin_received())
                    client.close();
            }
            pc.printf("Disconnected.\r\n");
        }
    }
}
