/* Senior Project Bluetooth bicycle speedometer
Author: Michael Galis
This is the main file, it implements both Acceleration Service and Reed Switch
Service to send all the necessary data over bluetooth in organized packages. 
Also there is code to reed from the accelerometer over an I2C connection.
*/

#include "mbed.h"
#include "ble/BLE.h"
#include "MMA8452Q.h"
#include "AcclerationService.h"
#include "ReedSwitchService.h"
#include "BLE_Init.h"

#define REED_SWITCH     P0_5

MMA8452Q accel(P0_10, P0_8, 0x1D);  //Declare accel object at I2C pins(P0_0 -> SDA, P0_1 -> SCL, 0x1D -> Accelerometer Address )
Ticker ticker;
float x,y,z;                        //variables assigned values to read x, y, and z accelerometer numbers
InterruptIn button(REED_SWITCH);

enum {                                                  //Different states of the reed switch
    RELEASED = 0,
    PRESSED,
    IDLE
};
static uint8_t reedSwitchState = IDLE;                  //Reed switch is initially idle
static volatile bool  triggerSensorPolling = false;

void reedSwitchPressedCallback(void)            //Change the Reed switch state to Pressed
{
    reedSwitchState = PRESSED;  
}

void reedSwitchReleasedCallback(void)           //Change the Reed switch state to Released
{
    reedSwitchState = RELEASED;
}

void periodicCallback(void)
{
    triggerSensorPolling = true;
    
}

int main(void)
{
    button.fall(reedSwitchPressedCallback);
    button.rise(reedSwitchReleasedCallback);
    
    BLE &ble = BLE::Instance();
    ble.init(bleInitComplete);
    
    accel.init();
    ticker.attach(periodicCallback,0.2);
    
    /* SpinWait for initialization to complete. This is necessary because the
     * BLE object is used in the main loop below. */
    while (ble.hasInitialized()  == false) { /* spin loop */ }
    
    while (true) {
        if (reedSwitchState != IDLE) {                                      //When the Reed Switch changes states
            reedSwitchServicePtr->updateReedSwitchState(reedSwitchState);   //update the value over ble
            reedSwitchState = IDLE;
        }
        if (triggerSensorPolling && ble.getGapState().connected)
        {
            triggerSensorPolling = false;
            if(accel.available())
            {
                x=accel.readX(); 
                y=accel.readY();
                z=accel.readZ();
                   
                accelerationServicePtr->updateXData(x);
                accelerationServicePtr->updateYData(y);
                accelerationServicePtr->updateZData(z);
                accelerationServicePtr->updateALLState(x,y,z);
            }
        }
        ble.waitForEvent();
    }
}
