/* Senior Project Bluetooth bicycle speedometer
Author: Michael Galis
This header file describes the Reed Switch Service that I created to be able
to send the state of the reed switch as a magnet passes by.
*/

#ifndef __BLE_BUTTON_SERVICE_H__
#define __BLE_BUTTON_SERVICE_H__

class ReedSwitchService {
public:
    const static uint16_t REED_SWITCH_SERVICE_UUID              = 0xA006;
    const static uint16_t REED_SWITCH_STATE_CHARACTERISTIC_UUID = 0xA007;

    ReedSwitchService(BLE &_ble, bool reedSwitchPressedInitial) :
        ble(_ble), 
        reedSwitchState(REED_SWITCH_STATE_CHARACTERISTIC_UUID, &reedSwitchPressedInitial, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY)
    {
        GattCharacteristic *charTable[] = {&reedSwitchState};
        GattService         reedSwitchService(ReedSwitchService::REED_SWITCH_SERVICE_UUID, charTable, sizeof(charTable) / sizeof(GattCharacteristic *));
        ble.gattServer().addService(reedSwitchService);
    }

    void updateReedSwitchState(bool newState) 
    {
        ble.gattServer().write(reedSwitchState.getValueHandle(), (uint8_t *)&newState, sizeof(bool));
    }

private:
    BLE                              &ble;
    ReadOnlyGattCharacteristic<bool>  reedSwitchState;
};

#endif /* #ifndef __BLE_BUTTON_SERVICE_H__ */
