/* Senior Project Bluetooth bicycle speedometer
Author: Michael Galis
This header file describes the Acceleration Service that I created to be able
to send the x, y, and z accelerations as the bicycle is moving. These 
accelerations will be used by the phone to calculate the speed of the bicycle.
*/

#ifndef __BLE_SERVICE_H__
#define __BLE_SERVICE_H__

class AccelerationService {
public:
    const static uint16_t ACCELERATION_SERVICE_UUID = 0xA010;
    const static uint16_t X_CHARACTERISTIC_UUID     = 0xA011;
    const static uint16_t Y_CHARACTERISTIC_UUID     = 0xA012;
    const static uint16_t Z_CHARACTERISTIC_UUID     = 0xA013;
    const static uint16_t ALL_CHARACTERISTIC_UUID   = 0x0014;

    AccelerationService(BLE &_ble) :
        ble(_ble), 
        xData(X_CHARACTERISTIC_UUID, 0, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY),
        yData(Y_CHARACTERISTIC_UUID, 0, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY),
        zData(Z_CHARACTERISTIC_UUID, 0, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY),
        allState(ALL_CHARACTERISTIC_UUID, 0, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY)
    {
        GattCharacteristic *charTable[] = {&xData,&yData, &zData, &allState};
        GattService         accelerationService(AccelerationService::ACCELERATION_SERVICE_UUID, charTable, sizeof(charTable) / sizeof(GattCharacteristic *));
        ble.gattServer().addService(accelerationService);
    }

    void updateXData(float newData) 
    {
        int length = sizeof(float);
        uint8_t bytes[sizeof(float)]; 
        for(int i = 0; i < length; i++)
        {
            bytes[i] = ((uint8_t*)&newData)[i];
        }
        int n = sizeof(bytes); 
        ble.gattServer().write(xData.getValueHandle(), (uint8_t *)&bytes, n);
        //int n = sizeof(uint8_t); 
        //ble.gattServer().write(xData.getValueHandle(), (uint8_t *)&newData, n); 
    }
    
    void updateYData(float newData) 
    {
        int length = sizeof(float);
        uint8_t bytes[sizeof(float)];
        for(int i = 0; i < length; i++)
        {
            bytes[i] = ((uint8_t*)&newData)[i];
        } 
        int n = sizeof(bytes);
        ble.gattServer().write(yData.getValueHandle(), (uint8_t *)&bytes, n); 
    }
    
    void updateZData(float newData) 
    {
        int length = sizeof(float);
        uint8_t bytes[sizeof(float)];
        for(int i = 0; i < length; i++)
        {
            bytes[i] = ((uint8_t*)&newData)[i];
        }
        int n = sizeof(bytes);
        ble.gattServer().write(zData.getValueHandle(), (uint8_t *)&bytes, n); 
    }
    
    void updateALLState(float newState,float newStatey,float newStatez) {
        
        int length = 14;
        uint8_t bytes[length]; 
        
        bytes[0] = ((uint8_t*)&newState)[0];
        bytes[1] = ((uint8_t*)&newState)[1];
        bytes[2] = ((uint8_t*)&newState)[2];
        bytes[3] = ((uint8_t*)&newState)[3];
        bytes[4] = 0xff;
        bytes[5] = ((uint8_t*)&newStatey)[0];
        bytes[6] = ((uint8_t*)&newStatey)[1];
        bytes[7] = ((uint8_t*)&newStatey)[2];
        bytes[8] = ((uint8_t*)&newStatey)[3];
        bytes[9] = 0xff;
        bytes[10] = ((uint8_t*)&newStatez)[0];
        bytes[11] = ((uint8_t*)&newStatez)[1];
        bytes[12] = ((uint8_t*)&newStatez)[2];
        bytes[13] = ((uint8_t*)&newStatez)[3];
            
        uint16_t n = sizeof(bytes) / sizeof(bytes[0]);
        ble.gattServer().write(allState.getValueHandle(), (uint8_t *)&bytes, n); //zapisanie danych do charakterystyki
    }

private:
    BLE                              &ble;
    ReadOnlyGattCharacteristic<float>  xData;
    ReadOnlyGattCharacteristic<float>  yData;
    ReadOnlyGattCharacteristic<float>  zData;
    ReadOnlyArrayGattCharacteristic<uint8_t, 14> allState;
};

#endif /* #ifndef __BLE_BUTTON_SERVICE_H__ */
