/* WiFi Example
 * Copyright (c) 2018 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "mbed.h"
#include "TCPSocket.h"
 
#define WIFI_IDW0XX1    2

#define TS_DEVICE "StmWifi" //mettre le nom de votre canal TS
#define thingspeak_APIkey_write "2QCEO7RP079WP5R4" //mettre la clé écriture de votre canal TS
#define thingspeak_APIkey_read "OMFA9O4ZPHUXPRKB" //mettre la clé lecture de votre canal TS


#if (defined(TARGET_DISCO_L475VG_IOT01A) || defined(TARGET_DISCO_F413ZH))
#include "ISM43362Interface.h"
ISM43362Interface wifi(MBED_CONF_APP_WIFI_SPI_MOSI, MBED_CONF_APP_WIFI_SPI_MISO,
 MBED_CONF_APP_WIFI_SPI_SCLK, MBED_CONF_APP_WIFI_SPI_NSS, MBED_CONF_APP_WIFI_RESET,
  MBED_CONF_APP_WIFI_DATAREADY, MBED_CONF_APP_WIFI_WAKEUP, false);

#else // External WiFi modules

#if MBED_CONF_APP_WIFI_SHIELD == WIFI_IDW0XX1
#include "SpwfSAInterface.h"
SpwfSAInterface wifi(MBED_CONF_APP_WIFI_TX, MBED_CONF_APP_WIFI_RX);
#endif // MBED_CONF_APP_WIFI_SHIELD == WIFI_IDW0XX1

#endif

#include "mbed.h"
#include <chrono>
#include <iostream>

// Sensors drivers present in the BSP library
#include "stm32l475e_iot01_gyro.h"
#include "stm32l475e_iot01_accelero.h"

// pour NFC
#include "M24SR.h"
#include "ReadUriCallbacks.h"
#include "WriteUriCallbacks.h"


// Pins definition for the DISCO_L475VG_IOT01A board
#define NFC_I2C_SDA_PIN     PB_11
#define NFC_I2C_SCL_PIN     PB_10
#define NFC_GPO_PIN         PE_4
#define NFC_RF_DISABLE_PIN  PE_2

#define LED1_PIN    PA_5
#define LED2_PIN    PB_14
#define LED3_PIN    PC_9

#define M24SR_ADDR          0xAC

// Fin NFC


/* Status PIN */
DigitalOut sessionOpenLed(LED1_PIN); // tag session is open
DigitalOut ongoingOperationLed(LED2_PIN); // ongoing read/write operation
DigitalOut sessionClosedLed(LED3_PIN); // tag session is closed


/** Variable set to true when we receive an interrupt from the NFC component */
static volatile bool nfcInterruptFlag = false;

/** Variable set to true when the user press the board user button */
static volatile bool buttonPress = false;

/** NFC ISR called when the NFC component has a message ready */
static void nfc_interrupt_callback()
{
    nfcInterruptFlag = true;
}

static void set_button_press()
{
    buttonPress = true;
}


PwmOut R(D9);
PwmOut G(D10);
PwmOut B(D11);
AnalogIn analog_value0(A0);
AnalogIn analog_value1(A1);


DigitalOut led(LED1);

int chute = 0;

const char *sec2str(nsapi_security_t sec)
{
    switch (sec) {
        case NSAPI_SECURITY_NONE:
            return "None";
        case NSAPI_SECURITY_WEP:
            return "WEP";
        case NSAPI_SECURITY_WPA:
            return "WPA";
        case NSAPI_SECURITY_WPA2:
            return "WPA2";
        case NSAPI_SECURITY_WPA_WPA2:
            return "WPA/WPA2";
        case NSAPI_SECURITY_UNKNOWN:
        default:
            return "Unknown";
    }
}

int scan_demo(WiFiInterface *wifi)
{
    WiFiAccessPoint *ap;

    printf("Scan:\n");

    int count = wifi->scan(NULL,0);
    printf("%d networks available.\n", count);

    /* Limit number of network arbitrary to 15 */
    count = count < 15 ? count : 15;

    ap = new WiFiAccessPoint[count];
    count = wifi->scan(ap, count);
    for (int i = 0; i < count; i++)
    {
        printf("Network: %s secured: %s BSSID: %hhX:%hhX:%hhX:%hhx:%hhx:%hhx RSSI: %hhd Ch: %hhd\n", ap[i].get_ssid(),
               sec2str(ap[i].get_security()), ap[i].get_bssid()[0], ap[i].get_bssid()[1], ap[i].get_bssid()[2],
               ap[i].get_bssid()[3], ap[i].get_bssid()[4], ap[i].get_bssid()[5], ap[i].get_rssi(), ap[i].get_channel());
    }

    delete[] ap;
    return count;
}


//________________________________________________


void http_demo(NetworkInterface *net)
{
    TCPSocket socket;
    nsapi_error_t response;
    
    char sbuffer[256];
    char message[64];
    // mise en place des capteurs (accelerations et gyromètres)
    float sensor_value = 0;
    int16_t pDataXYZ[3] = {0};
    int16_t pDataXYZ_init[3] = {0};
    float pGyroDataXYZ[3] = {0};
    float pGyroDataXYZ_init[3] = {0};

    printf("Start sensor init\n");
    //  BSP_GYRO_Init();
    //  BSP_GYRO_GetXYZ(pGyroDataXYZ_init);
    BSP_ACCELERO_Init();
    BSP_ACCELERO_AccGetXYZ(pDataXYZ_init);
    float meas_r0;
    float meas_r1;
    float i;
    
    
    //mise en place du NFC
    InterruptIn userButton(USER_BUTTON);
    userButton.fall(set_button_press);

    // Create the NFC component
    I2C i2cChannel(NFC_I2C_SDA_PIN, NFC_I2C_SCL_PIN);
    
    M24SR nfcTag(M24SR_ADDR,i2cChannel, &nfc_interrupt_callback, NFC_GPO_PIN, NFC_RF_DISABLE_PIN);

    // init needed to enable the component
    nfcTag.init(NULL);
    // No call back needed since default behavior is sync
    nfcTag.get_session();
    nfcTag.manage_I2C_GPO(M24SR::I2C_ANSWER_READY); // Switch to async mode

    NDefLib::NDefNfcTag &tag = nfcTag.get_NDef_tag();


    // Create the callback to use to write a tag
    WriteUriCallbacks NDefWriteCallback(sessionOpenLed,ongoingOperationLed,sessionClosedLed);
    ReadUriCallbacks NDefReadCallback(sessionOpenLed,ongoingOperationLed,sessionClosedLed);
    tag.set_callback(&NDefWriteCallback); // Set the callback
    tag.open_session(); // Start the callback chain
 
    // declaration des variables utilisées pour le temps
    
    auto mseconds_last = 0;


//----

    /* Loop */  
    while(true)
    {
// Open a socket on the network interface, and create a TCP connection to thingspeaks.com
    // Si detection de NFC
        if (nfcInterruptFlag) 
        {
            nfcInterruptFlag = false;
            // Manage an async event from the NFC component
            nfcTag.manage_event();
        }
        
        __WFE(); // Wait For Event

        // Clignotants
        
        meas_r0 = analog_value0.read();
        printf("\n\rx= %f ", meas_r0);
        meas_r1 = analog_value1.read();
         
        if (meas_r0 > 0.8)
        {
            G.write(0);
            i=0;
            while (i<12  and meas_r1 < 0.8)
            {
                B.write(1);
                meas_r1 = analog_value1.read();
                wait(0.2);
                B.write(0);
                wait(0.2);
                printf("y= %f \n\r", meas_r1);
                i=i+1;
            }
        }
        if (meas_r0 < 0.5)
        {
            B.write(0);
            i=0;
            while (i<12  and meas_r1 < 0.8)
            {
                G.write(1);
                meas_r1 = analog_value1.read();
                wait(0.2);
                G.write(0);
                wait(0.2);
                printf("y= %f \n\r", meas_r1);
                i=i+1;
            }
        }
        
        
        //feux de freinages
        
        BSP_ACCELERO_AccGetXYZ(pDataXYZ);
        printf("\n\rACCELERO_X = %d", pDataXYZ[0]);

        
        
        
        if (pDataXYZ[0] < -40){
            R.write(1);
            wait(1.2);
            R.write(0);       
            }
        if (pDataXYZ[2] < 750){
            R.write(1);
            chute = 1;
            }
        else{
            chute = 0;
            R.write(0);
            }
        
    
    socket.open(net);
    response = socket.connect("api.thingspeak.com", 80);
    if(0 != response)
    {
        printf("Error connecting: %d\n", response);
        socket.close();
        return;
    }
printf("Connected to the Server\n");
//lecture des données des capteurs et actualisation des variables à transmettre
    //captX=10; // | Pour illustration :
    //captY=20; // | dans cet exemple on attribue des valeurs constantes aux variables
    //captZ=30; // | captX =10, captY=20, captZ=30
    
    /* Construct content of HTTP command */ //message à transmettre (données des capteurs)
    sprintf(message, "{\"field1\": %0.2f, \"field2\": %0.2f, \"field3\": %0.2f}", meas_r0, (double)pDataXYZ[0], (double) chute);
    printf("Content Length = %d\r\n", (int)strlen(message));
    
    /* Construct HTTP command to send */  // Phase de transmission des données à ThingSpeaks.com
    sprintf(sbuffer, "GET /update?api_key=%s HTTP/1.1\r\nHost: api.thingspeak.com\r\nContent-Type: application/json\r\nContent-Length: %d\r\n\r\n%s", thingspeak_APIkey_write, (int)strlen(message),message);
    printf("HTTP command %s\r\n", sbuffer);
    // Send a simple http request
    printf("Sending HTTP request to thingspeak.com...\n");
    nsapi_size_t size = strlen(sbuffer);
    response = 0;
    while(size)
    {
        response = socket.send(sbuffer+response, size);
        if (response < 0)
        {
            printf("Error sending data: %d\n", response);
            socket.close();
            return;
        }
        else
        {
            size -= response;
            // Check if entire message was sent or not
            printf("sent %d [%.*s]\n", response, strstr(sbuffer, "\r\n")-sbuffer, sbuffer);
        }
    }
    // Receive a simple http response and print out the response line
    char rbuffer[64];
    response = socket.recv(rbuffer, sizeof rbuffer);
    if (response < 0)
    {
        printf("Error receiving data: %d\n", response);
    }
    else
    {
        printf("recv %d [%.*s]\n", response, strstr(rbuffer, "\r\n")-rbuffer, rbuffer);
    }
    // Close the socket to return its memory and bring down the network interface
    socket.close();
    }
}




//---------------------------------------------------------------------------------------








int main()
{
    int count = 0;

    printf("WiFi example\n\n");
    printf("\nConnecting to %s...\n", MBED_CONF_APP_WIFI_SSID);
    int ret = wifi.connect(MBED_CONF_APP_WIFI_SSID, MBED_CONF_APP_WIFI_PASSWORD, NSAPI_SECURITY_WPA_WPA2);
    if (ret != 0)
    {
    printf("\nConnection error\n");
    return -1;
    }

    printf("Success\n\n");
    printf("MAC: %s\n", wifi.get_mac_address());
    printf("IP: %s\n", wifi.get_ip_address());
    printf("Netmask: %s\n", wifi.get_netmask());
    printf("Gateway: %s\n", wifi.get_gateway());
    printf("RSSI: %d\n\n", wifi.get_rssi());

    http_demo(&wifi);

    wifi.disconnect();

    printf("\nDone\n");
}
