#ifndef IM315_H
#define IM315_H

#include "mbed.h"

class IM315 {
public:
        IM315(PinName tx, PinName rx);

    uint8_t get_all_switch(void);
    bool get_switch(int num);

    enum AxisId {
        Stick0X, Stick0Y, Stick1X
    };
    int get_raw_axis(AxisId id);
    double get_axis(AxisId id);
    void initialize_axis(void);
    void initialize_axis(AxisId id);

    enum ErrorFactor {
        NoError, NoDataError, TimeoutError, InvalidDataError, SerialBusyError
    };
    ErrorFactor get_error();

    bool is_axis_initialized;

private:
    Serial device;

    void data_receive_isr();
    int buffer_head;
    uint8_t received_data[8];
    uint8_t received_buffer[8];
    int axis_center[3];
    static const double axis_threshold = 0.1;
    
    Timer error_timer;
    int error_count;
    ErrorFactor error_id;
    static const int error_threshold = 5;
    static const double timeout_time = 0.5;
};

#endif
