#ifndef GETCONTROLLER_H
#define GETCONTROLLER_H

#include "mbed.h"
#include <math.h>

class GetCon
{
    public:
        GetCon(PinName tx, PinName rx);//You don't have to give me the argument when not special case. Baud is 115200.
        uint8_t GetAllSW();//I'll return MSB sw7 sw6 sw5 sw4 sw3 sw2 sw1 sw0 LSB. Each size is 1bit.
        bool GetSW(int num);//Please give me 0~7 value, you will get value's switch
        double Get0X();//We return each axis for double.
        double Get0Y();//The range is -1~0~+1.
        double Get1X();//The range of 0 is a little wide.(0 = -0.012 < ~ < +0.012)
        double Get1Y();//We haven't setting using joysticks yet. So we may improvement.
        bool GetError();//If signal is not come, I tell you true for bool.
        void debug(const char *format, ...);
        uint8_t data[9];
    private:
        Serial device;
        Ticker errorflg;
        void GetData();
        double GetAxis(int num);
        void Errorflg();
        int cnt;
        //uint8_t data[9];
        int ecnt;
        int inicnt;
        int iniaxis[4];
};

#endif