#include "GetController.h"

GetCon::GetCon(PinName tx, PinName rx):device(tx, rx)
{
    ecnt = 5;
    inicnt = 2;
    
    device.baud(115200);
    errorflg.attach(this, &GetCon::Errorflg, 0.03);
    device.attach(this, &GetCon::GetData, Serial::RxIrq);
}

void GetCon::GetData()
{
    ecnt = 0;
    uint8_t buff;
    buff = device.getc();
    if (buff == 0x3a)
    {
        cnt = 0;
    }
    else
    {
        if (cnt < 9)
        {
            data[cnt] = buff;
            cnt++;
            
        }
        else
        {
            cnt = 0;
        }
    }
    
    if (inicnt < 10)
    {
        if (cnt == inicnt)
        {
            iniaxis[(inicnt/2)-1] = data[inicnt-1] << 8 | data[inicnt];
            inicnt += 2;
        }
    }   
}

void GetCon::Errorflg()
{
    if (ecnt < 5)
    {
        ecnt++;
    }
}

uint8_t GetCon::GetAllSW()
{
    return data[0];
}

bool GetCon::GetSW(int num)
{
    return (bool)(data[0] & (int)(pow(2.0, (double)num)));
}

double GetCon::GetAxis(int num)
{
    double axis = 0;
    num *= 2;
    
    axis = (double)((data[num+1] << 8 | data[num+2]) - iniaxis[num/2]) / 511;
    
    if (axis > -0.012 && axis < 0.012)
    {
        axis = 0;
    }
    else if (axis < -1)
    {
        axis = -1;
    }
    else if (axis > 1)
    {
        axis = 1;
    }
    
    return axis;
}

double GetCon::Get0X()
{
    return GetAxis(0);
}

double GetCon::Get0Y()
{
    return GetAxis(1);
}

double GetCon::Get1X()
{
    return GetAxis(2);
}

double GetCon::Get1Y()
{
    return GetAxis(3);
}

bool GetCon::GetError()
{
    bool eflg;
    
    if (ecnt == 5)
    {
        eflg = true;
    }
    else
    {
        eflg = false;
    }
    
    return eflg;
}

void GetCon::debug(const char *format, ...) {
    va_list arg;

    va_start(arg, format);
    device.vprintf(format, arg);
    va_end(arg);
}
