#ifndef LAMBDA_CONTROLLER_H
#define LAMBDA_CONTROLLER_H

#include "mbed.h"

class LambdaController {
public:
    LambdaController(PinName tx, PinName rx, PinName hzpin);

    uint16_t get_all_switch(void);
    bool get_switch(int num);

    enum AxisId {
        Stick0X, Stick0Y, Stick1X, Stick1Y
    };
    int get_raw_axis(AxisId id);
    double get_axis(AxisId id);
    void initialize_axis(void);
    void initialize_axis(AxisId id);

    enum ErrorFactor {
        NoError, NoDataError, TimeoutError, InvalidDataError, SerialBusyError
    };
    ErrorFactor get_error();

private:
    Serial device;
    DigitalIn hzjudge;

    void data_receive_isr();
    int buffer_head;
    uint8_t received_data[11];
    uint8_t received_buffer[11];
    bool is_axis_initialized;
    int axis_center[4];
    static const double axis_threshold = 0.012;
    
    Timer error_timer;
    int error_count;
    ErrorFactor error_id;
    static const int error_threshold = 5;
    static const double timeout_time = 0.5;
};

#endif