#ifndef V_CONTROLLER_H
#define V_CONTROLLER_H

#include "mbed.h"

// _____________________
//|                     |
//|   7             5   |
//| 1   0         4   3 |
//|   6             2   |
//|                     |
//|    +1Y       +0Y    |
//|  -1X +1X   -0X +0X  |
//|    -1Y       -1Y    |
//|_____________________|

class VController {
public:
    VController(PinName tx, PinName rx, PinName hzpin);

    uint8_t get_all_switch(void);
    bool get_switch(int num);

    enum AxisId {
        Stick0X, Stick0Y, Stick1X, Stick1Y
    };
    int get_raw_axis(AxisId id);
    double get_axis(AxisId id);
    void initialize_axis(void);
    void initialize_axis(AxisId id);

    enum ErrorFactor {
        NoError, NoDataError, TimeoutError, InvalidDataError, SerialBusyError
    };
    ErrorFactor get_error();

private:
    Serial device;
    DigitalIn hzjudge;

    void data_receive_isr();
    int buffer_head;
    uint8_t received_data[10];
    uint8_t received_buffer[10];
    bool is_axis_initialized;
    int axis_center[4];
    static const double axis_threshold = 0.012;
    
    Timer error_timer;
    int error_count;
    ErrorFactor error_id;
    static const int error_threshold = 5;
    static const double timeout_time = 0.5;
};

#endif



