#include "T_motor.h"

void T_motor::setAddr(int addr_)
{
    addr = addr_;
}

void T_motor::init(char addr,int freq = 100000)
{
    setAddr(addr);
    i2c->frequency(freq);
    char d = 0;
    i2c->write((addr+1) << 1,&d,1);
    wait(0.01);
}

T_motor::T_motor(I2C* i2c_,int addr):i2c(i2c_)
{
    init(addr);
}

T_motor& T_motor::operator=(float fval)// -1 <= fval <= 1
{
    if(fabs(fval) < 0.005f)free();
    else {
        if(fval < 0) run(1,char(-1*fval*255));
        else if(fval > 0) run(0,char(fval*255));
    }
    return *this;
}

void T_motor::control(float fval)//copy from operator
{
    if(fabs(fval) < 0.005f)free();
    else {
        if(fval < 0) run(1,char(-1*fval*255));
        else if(fval > 0) run(0,char(fval*255));
    }
}

bool T_motor::run(char mode,char speed)
{
    bool f = 0;
    char d = speed;

    if(mode == 0 || mode == 1)f = i2c->write((addr+mode) << 1,&d,1);
    wait(0.01);
    return f;
}

bool T_motor::stop()
{
    return run(1,0);
}

bool T_motor::free()
{
    return run(0,0);
}

