#ifndef PS3_H
#define PS3_H
#include "mbed.h"

#define MARU 64
#define BATU 32
#define SIKAKU 1
#define SANKAKU 16
#define UE 1
#define SITA 2
#define MIGI 4
#define HIDARI 8
#define LEFT1 2
#define LEFT2 4
#define RIGHT1 8
#define RIGHT2 16

class PS3 : public Serial
{
    public:
        PS3(PinName TX, PinName RX);
        /*{
            PS3Data[0] = 128;
            PS3Data[1] = 0;
            PS3Data[2] = 0;
            PS3Data[3] = 64;
            PS3Data[4] = 64;
            PS3Data[5] = 64;
            PS3Data[6] = 64;
            PS3Data[7] = 0;
            baud(2400);
            Serial::attach(this, &PS3::getdata, Serial::RxIrq);
        }*/
        
        bool maru();
        /*{
            return PS3Data[2] & MARU;
        }*/
        
        bool batu();
        /*{
            return PS3Data[2] & BATU;
        }*/
        
        bool sikaku();
        /*{
            return PS3Data[1] & SIKAKU;
        }*/
        
        bool sankaku();
        /*{
            return PS3Data[2] & SANKAKU;
        }*/
        
        bool ue();
        /*{
            return PS3Data[2] & UE && !(PS3Data[2] & SITA);
        }*/
        
        bool sita();
        /*{
            return PS3Data[2] & SITA && !(PS3Data[2] & UE);
        }*/
        
        bool start();
        /*{
            return PS3Data[2] & UE && PS3Data[2] & SITA;
        }*/
        
        bool migi();
        /*{
            return PS3Data[2] & MIGI && !(PS3Data[2] & HIDARI);
        }*/
        
        bool hidari();
        /*{
            return PS3Data[2] & HIDARI && !(PS3Data[2] & MIGI);
        }*/
        
        bool select();
        /*{
            return PS3Data[2] & MIGI && PS3Data[2] & HIDARI;
        }*/
        
        bool L1();
        /*{
            return PS3Data[1] & LEFT1;
        }*/
        
        bool L2();
        /*{
            return PS3Data[1] & LEFT2;
        }*/
        
        bool R1();
        /*{
            return PS3Data[1] & RIGHT1;
        }*/
        
        bool R2();
        /*{
            return PS3Data[1] & RIGHT2;
        }*/
        
        int8_t analogLX();
        /*{
            if(PS3Data[3] == 0)
                PS3Data[3]=1;
            return PS3Data[3]-64;
        }*/
        
        int8_t analogLY();
        /*{
            if(PS3Data[4] == 0)
                PS3Data[4]=1;
            return (PS3Data[4]-64)*(-1);
        }*/
        
        int8_t analogRX();
        /*{
            if(PS3Data[5] == 0)
                PS3Data[5]=1;
            return PS3Data[5]-64;
        }*/
        
        int8_t analogRY();
        /*{
            if(PS3Data[6] == 0)
                PS3Data[6]=1;
            return (PS3Data[6]-64)*(-1);
        }*/
        
        
        
    private:

        int8_t sum;
        uint8_t PS3Data[8];
        uint8_t GetData[8];
    
        void getdata();
        /*{
            while(Serial::getc() != 128)
            {
            }
            for(int i = 1;i < 8;i++)
            {
                GetData[i] = Serial::getc();
            }
            
            sum = GetData[1] + GetData[2];
            for(int i = 3;i < 7;i++)
            {
               sum += GetData[i] - 64;
            }
                
            if(sum < 0)
                 sum+=128;
                    
            if(sum == GetData[7])
            {
                for(int i = 0;i < 8;i++)
                {
                    PS3Data[i]=GetData[i];
                }
            }
        }*/
        
};
            
#endif            
            
        