#ifndef NUNCHUCK_H
#define NUNCHUCK_H


#include "mbed.h"

#define NUNCHUCK_ANALOGDATA 1  //1 : analog   0 : degital
#define NUNCHUCK_DEADZONE 6    //analog stick's deadzone
#define NUNCHUCK_ADDR    0xA4  // 0x52 << 1

#define PI 3.14159265358979

class Nunchuck : I2C
{
    public:

        Nunchuck(PinName SDA, PinName SCL);
        int8_t analogx();
        int8_t analogy();
        double analograd();
        double analogdeg();
        double analogrange();
        int accx();
        int accy();
        int accz ();
        bool buttonc();
        bool buttonz();
    
    private:
        Timer timer;
        bool flag;
        bool init();
        char data[6];
        void getdata();
};

#endif