#include "PS3.h"

        PS3::PS3(PinName TX, PinName RX) : Serial(TX, RX)
        {
            PS3Data[0] = 128;
            PS3Data[1] = 0;
            PS3Data[2] = 0;
            PS3Data[3] = 64;
            PS3Data[4] = 64;
            PS3Data[5] = 64;
            PS3Data[6] = 64;
            PS3Data[7] = 0;
            baud(2400);
            Serial::attach(this, &PS3::getdata, Serial::RxIrq);
        }
        
        bool PS3::maru()
        {
            return PS3Data[2] & MARU;
        }
        
        bool PS3::batu()
        {
            return PS3Data[2] & BATU;
        }
        
        bool PS3::sikaku()
        {
            return PS3Data[1] & SIKAKU;
        }
        
        bool PS3::sankaku()
        {
            return PS3Data[2] & SANKAKU;
        }
        
        bool PS3::ue()
        {
            return PS3Data[2] & UE && !(PS3Data[2] & SITA);
        }
        
        bool PS3::sita()
        {
            return PS3Data[2] & SITA && !(PS3Data[2] & UE);
        }
        
        bool PS3::start()
        {
            return PS3Data[2] & UE && PS3Data[2] & SITA;
        }
        
        bool PS3::migi()
        {
            return PS3Data[2] & MIGI && !(PS3Data[2] & HIDARI);
        }
        
        bool PS3::hidari()
        {
            return PS3Data[2] & HIDARI && !(PS3Data[2] & MIGI);
        }
        
        bool PS3::select()
        {
            return PS3Data[2] & MIGI && PS3Data[2] & HIDARI;
        }
        
        bool PS3::L1()
        {
            return PS3Data[1] & LEFT1;
        }
        
        bool PS3::L2()
        {
            return PS3Data[1] & LEFT2;
        }
        
        bool PS3::R1()
        {
            return PS3Data[1] & RIGHT1;
        }
        
        bool PS3::R2()
        {
            return PS3Data[1] & RIGHT2;
        }
        
        int8_t PS3::analogLX()
        {
            if(PS3Data[3] == 0)
                PS3Data[3] = 1;
            return PS3Data[3] - 64;
        }
        
        int8_t PS3::analogLY()
        {
            if(PS3Data[4] == 0)
                PS3Data[4] = 1;
            return (PS3Data[4] - 64) * (-1);
        }
        
        int8_t PS3::analogRX()
        {
            if(PS3Data[5] == 0)
                PS3Data[5] = 1;
            return PS3Data[5] - 64;
        }
        
        int8_t PS3::analogRY()
        {
            if(PS3Data[6] == 0)
                PS3Data[6] = 1;
            return (PS3Data[6] - 64) * (-1);
        }
        
        
        
        void PS3::getdata()
        {
            while(Serial::getc() != 128)
            {
            }
            for(int i = 1; i < 8; i++)
            {
                GetData[i] = Serial::getc();
            }
            
            sum = GetData[1] + GetData[2];
            for(int i = 3; i < 7; i++)
            {
               sum += GetData[i] - 64;
            }
                
            if(sum < 0)
                 sum += 128;
                    
            if(sum == GetData[7])
            {
                for(int i = 0; i < 8; i++)
                {
                    PS3Data[i] = GetData[i];
                }
            }
        }