#include "mbed.h"
#include "omuni.h"
#include "solenoid.h"

#define DEBUG 0

#define CON_OFFSET 15

I2C i2c(p28, p27);
omuni omu(&i2c, 0x10, 0x14, 0x16);
solenoid sol(&i2c, 0x20);

Serial con(p9, p10);
Serial master(p13,p14);
Serial pc(USBTX, USBRX);

BusOut serialsel(p19,p20,LED1,LED2);
Timer serialtimer;
//Ticker readtimer;

char ConData[2][12];
char offset[4];

/*
void mbedreset()
{
    NVIC_SystemReset();
}
*/

void GetData()
{
    //readtimer.attach(&mbedreset, 1);
    static bool main_flag = 1 ;
    if ( con.getc() == 'H' ) {
         ConData[0][0] = 'H';
         for (int i = 1; i < 12; i++)
         {
             char t = (char)con.getc();
             ConData[0][i] = t;
         }
         for (int i = 0; i < 12; i++)
         {
             char t = (char)con.getc();
             ConData[1][i] = t;
         }
        for(int i = 0; i < 12; i++)
        {
                master.putc(ConData[0][i]);
        }
        for(int i = 0; i < 12; i++)
        {
                master.putc(ConData[1][i]);
        }
        if(main_flag)
        {
            /*
            
            offset[0] = ConData[0][1];
            offset[1] = ConData[0][2];
            offset[2] = ConData[1][1];
            offset[3] = ConData[1][2];
            */
            serialtimer.start();
            main_flag = 0;
        }
        //ConData[0][1] -= offset[0];
        //ConData[0][2] -= offset[1];
        //ConData[1][1] -= offset[2];
        //ConData[1][2] -= offset[3];
        
        if( (char)255 - CON_OFFSET < ConData[1][1] || ConData[1][1] < CON_OFFSET)
            ConData[1][1] = 0;
            
        serialtimer.reset();
    }
    //readtimer.detach();
}


int main() {
        serialsel = 0x05;
        con.baud(115200);
        master.baud(115200);
        pc.baud(115200);
        con.attach(&GetData,Serial::RxIrq);
        
        serialtimer.stop();
        serialtimer.reset();
        
        while(1){
            char MotorData[] = {'H', ConData[0][1], ConData[0][2], ConData[1][1], ConData[1][2]};
            omu.out(MotorData);

            char soldata = ((ConData[0][3] << 2) + ConData[1][3]) << 4;
            sol = soldata;
            
            if(serialtimer.read_ms() > 500)
            {
                serialsel = ~serialsel;
                serialtimer.reset();
                char MotorReset[] = {'H', 0, 0, 0, 0};
                omu.out(MotorReset);
            }

            #if DEBUG 
            for(int i = 0; i < 12; i++)
            {
                    pc.printf("%3d ",ConData[0][i]);
            }
            for(int i = 0; i < 12; i++)
            {
                    pc.printf("%3d ",ConData[1][i]);
            } 
            pc.printf("\n\r");
            
            for(int i = 0; i < 4; i++)
            {
                    pc.printf("%3d ",offset[i]);
            }
            printf("\n");
            
            printf("%d\n",soldata);
            #endif
        }  
}
