/* Copyright (c) 2016 Aconno. All Rights Reserved.
 *
 * Licensees are granted free, non-transferable use of the information. NO
 * WARRANTY of ANY KIND is provided. This heading must NOT be removed from
 * the file.
 *
 */
 
#ifndef WAVR4
#define WAVR4

#include "drv8837.h"
#include "mbed.h"
#include <events/mbed_events.h>
#include "ble/BLE.h"
#include <stdbool.h>

/**
 *  Settings for general behavior
 */
#define PRODUCT_ID                  (0x05)          // WAVR product id
#define VERSION_NUMBER              (0x01)          // version of the software         
#define EVENT_QUEUE_SIZE            (16)             // size of the event queue
 
 /**
 *  General IO pins
 */
#define PIN_LED_RED                 (p12)           // Module red LED
#define PIN_LED_BLUE                (p14)           // Module blue LED
#define PIN_LED_GREEN               (p15)           // Module green LED

/** battery pins */
#define PIN_BAT_VOL                 (p3)            // battery voltage
#define MAX_BAT_V                   (4.2)           // maximum battery voltage
#define MIN_BAT_V                   (3.7)           // minimum battery voltage
#define R3                          (330000)        // upper voltage splitter R 
#define R4                          (100000)        // lower voltage splitter R
 
/**
 *  Pins for the DRV8837 motor controller
 */
#define PIN_M_NSLEEP                (p21)           // inverted sleep motor driver
#define PIN_M_IN1                   (p10)           // motor driver in1
#define PIN_M_IN2                   (p9)            // motor driver in2
#define PIN_M_CUR                   (p2)            // motor driver current sense
#define M_STALL_CUR                 (0.09)           // stall current in ampere

/**
 *  Settings for BT
 */
#define DEVICE_NAME                 "aconno_roawr"  // BT name of the device
#define TX_POWER                    (4)             // TX power (in dB)
#define MSD_SIZE                    (29)            // Manufacturer Specific Data lenght (in B)
#define ADVERTISING_INTERVAL_MS     (500)           // interval in which the device is advertised, at least 100ms

const float V_MULTI =               3.3 * (R3 + R4) / R4; // multiplier for measured voltage to battery voltage

#endif