/*  code is property of aconno.de */


#ifndef COUNTDOWN_SERVICE
#define COUNTDOWN_SERVICE

#include <stdbool.h>
#include "mbed.h"
#include <events/mbed_events.h>
#include "ble/BLE.h"


/** definitions for UUID's */
static const char* UUID_COUNTDOWN_SERVICE = "8ca81a4b-6182-4b04-ba9c-e4002a4a7a8b";    // UUID of the contdown service
static const char* UUID_W_CHARACTERISTIC = "6a9e371d-a3fc-4a34-bd21-ad887188532c";  // UUID of the time characteristic
static UUID UUID_Service(UUID_COUNTDOWN_SERVICE);
static UUID UUID_WCharacteristic(UUID_W_CHARACTERISTIC);

typedef struct Buffer {
    uint8_t data[512];
} Buffer;

class CountdownService {
typedef CountdownService Self;
public:    
    CountdownService(GattServer &server, Callback<void(uint8_t*, uint16_t)> w_changed_callback):
    server(server),
    wChar(UUID_WCharacteristic, NULL),
    onWCharWritten(w_changed_callback) {
        
        GattCharacteristic *charTable[] = {&wChar};
        GattService service(UUID_Service, charTable, sizeof(charTable) / sizeof(GattCharacteristic *));
        
        server.addService(service); 
        server.onDataWritten(this, &CountdownService::onDataWritten);
    }
    
    void GetWCharValue(uint8_t *data, uint16_t *length) {
        server.read(wChar.getValueHandle(), data, length);
    }
    
private:
    void onDataWritten(const GattWriteCallbackParams *params) {
        if (params->handle == wChar.getValueHandle()) {
            uint16_t length;
            uint8_t data[512];
            GetWCharValue(data, &length);
            onWCharWritten(data, length);
        }
    }
    
private:
    GattServer &server;
    WriteOnlyGattCharacteristic<Buffer> wChar;
    Callback<void(uint8_t, 512)> onWCharWritten;
};
#endif