#include "mbed.h"
 #include "USBJoystick.h"
 
 USBJoystick joystick;
DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);

InterruptIn mybutton(USER_BUTTON);

double tempo = 0.3; // LED blinking delay
PinName pin = D7;
// Change LEDs blinking frequency
void change_blinking_frequency() {
    if (tempo == 0.3) // If leds have low frequency
        tempo = 0.1;  // Set the fast frequency
    else              // If leds have fast frequency
        tempo = 0.3;  // Set the low frequency
}

        InterruptIn interrupt(pin);
        Timer timer;

uint32_t interval;
uint32_t channels[9];
uint32_t channel;
bool done=false;

void rise()
{
    interval=timer.read_us();
    if(interval > 3000)
    {
        done = true;
        channel=0;
        return;
    }
    int length = interval - 1000;
    if(length < 0)
        length = 0;
    else if(length>1023)
        length=1023;
    length /= 4;
    length -= 127;
    
    channels[channel] = length;
    channel++;
}

int main() {
    // All LEDs are OFF
    myled1 = 0;
    myled2 = 0;
    myled3 = 0;
    myled4 = 0;

    // Change LEDs blinking frequency when button is pressed
    mybutton.fall(&change_blinking_frequency);
    timer.start();
    interrupt.rise(&rise);
//    interrupt.fall(this, &RadioChannel::fall);
uint8_t count=0;
    while(1) {
        if(done)
        {
            joystick.update(count, 0, channels[0], 0, 0, 0);
            done = false;
        }
         joystick.update(count, 0, channels[0], 0, 0, 0);
        count++;
        wait(0.001);
    }
}
