#include "mbed.h"
#include "USBJoystick.h"

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);

InterruptIn ppm(D7);
USBJoystick joystick;
double tempo = 0.3; // LED blinking delay

Timer timer;

volatile int period;

int16_t channels[9] ={0,0,0,0,0,0,0,0,0};
uint8_t curChannel = 0;
bool done=false;

// multiplex: min: 1050, mitte 1600, max 2150

void rise()
{
    period = timer.read_us();
    timer.reset();
    if(period > 3000)
    {
        curChannel = 0;
        done=true;
        return;
    }
    
    period -= 1580;
 /*   if(period  < -550)
        period = -550;
    if(period > 550)
        period = 550;
  */      
 /*   period*=255;
    period/=1100;*/
/*    int buf = period;
    int val = buf-128;
    if(val < -127)
        val = -127;
    if(val > 128)
        val = 128;
    channels[curChannel] = -val;
    */
    if(curChannel < 9)
        channels[curChannel] = -period; 
    curChannel++;
    myled1=1;
    myled2=0;
}

int main() {
    // All LEDs are OFF
    myled1 = 0;
    myled2 = 0;
    myled3 = 0;
    myled4 = 0;
    ppm.rise(&rise);
    timer.start();

    uint32_t count = 0;
    int16_t thr = 0;
    int16_t rudder = 0;
    int16_t x=0;
    int16_t y=0;

    while(1) {
       // wait(1.000);  // wait tempo
      
        if(done)
        {
            thr = channels[0];
            rudder = channels[1];
            x = channels[2];
            y = channels[3];
            done = 0;
            joystick.update(thr, rudder, x, y, channels[4], channels[5], channels[6], channels[7], count&0, 0);
        }

        count++;
    }
}
