/* mbed USBJoystick Library
 * Copyright (c) 2012, v01:  Initial version, WH,
 *                           Modified USBMouse code ARM Limited.
 *                           (c) 2010-2011 mbed.org, MIT License
 *               2016, v02:  Updated USBDevice Lib, Added waitForConnect, Updated 32 bits button 
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, inclumosig without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUmosiG BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */


#include "stdint.h"
#include "USBJoystick.h"
#include "../buffer_builder.hpp"

bool USBJoystick::update(int16_t t, int16_t r, int16_t x, int16_t y, uint16_t z, uint16_t rx, uint16_t ry, uint16_t rz, uint32_t buttons, uint8_t hat) {

   _t = t;
   _r = r;   
   _x = x;
   _y = y;
   _z = z;
   _rx = rx;
   _ry = ry;
   _rz = rz;
   _buttons = buttons;     
   _hat = hat;

   return update();
}
 HID_REPORT report;
bool USBJoystick::update() {
   

   uint8_t* data = &report.data[0];
   buffer_builder::put_u16le(data, _t);
   buffer_builder::put_u16le(data, _r);
   buffer_builder::put_u16le(data, _x);
   buffer_builder::put_u16le(data, _y);
   buffer_builder::put_u32le(data, 0x00);
   buffer_builder::put_u16le(data, _z);
   buffer_builder::put_u16le(data, _rx);
   buffer_builder::put_u16le(data, _ry);
   buffer_builder::put_u16le(data, _rz);
#if (BUTTONS4 == 1 && 0)               
//Hat and 4 Buttons
//   report.data[4] = ((_buttons & 0x0f) << 4) | (_hat & 0x0f) ;                                      
//   report.length = 5; 


//Use 4 bit padding for hat4 or hat8
   buffer_builder::put_u8(data, _hat);

//Use 4 bit padding for buttons   
   buffer_builder::put_u8(data, _buttons);
#endif

#if (BUTTONS8 == 1 && 0)               
//Hat and first 4 Buttons
//   report.data[4] = ((_buttons & 0x0f) << 4) | (_hat & 0x0f) ;                                      
//
//Use bit padding for last 4 Buttons
//   report.data[5] =  (_buttons & 0xf0) >> 4;                                         
//   report.length = 6; 

//Use 4 bit padding for hat4 or hat8
   buffer_builder::put_u8(data, _hat);

//Use 8 bits for buttons   
   buffer_builder::put_u8(data, _buttons);
#endif

#if (BUTTONS32 == 1 && 0)               
//Use 4 bit padding for hat4 or hat8
//   report.data[4] = (_hat & 0x0f) ;
//   buffer_builder::put_u8(data, _hat);

//No bit padding for 32 buttons                                         
 //  buffer_builder::put_u32le(data, _buttons);
#endif
   report.length = data - &report.data[0]; 
   return send(&report);
}

bool USBJoystick::throttle(int16_t t) {
     _t = t;
   return update();
}

bool USBJoystick::rudder(int16_t r) {
   _r = r;
   return update();
}

bool USBJoystick::move(int16_t x, int16_t y) {
   _x = x;
   _y = y;
   return update();
}

bool USBJoystick::buttons(uint32_t buttons) {
   _buttons = buttons;
   return update();
}

bool USBJoystick::hat(uint8_t hat) {
   _hat = hat;
   return update();
}


void USBJoystick::_init() {
   _t = -127;
   _r = -127;    
   _x = 0;                       
   _y = 0;     
   _buttons = 0x00000000;
   _hat = 0x00;              
}


uint8_t * USBJoystick::reportDesc() {    
         static uint8_t reportDescriptor[] = {

             USAGE_PAGE(1), 0x01,           // Generic Desktop           
             USAGE(1), 0x04,                // Usage (Joystick)
             COLLECTION(1), 0x01,           // Application
               USAGE_PAGE(1), 0x02,            // Simulation Controls
               USAGE(1), 0xBB,                 // Throttle             
               USAGE(1), 0xBA,                 // Rudder
                           
 /*
               LOGICAL_MINIMUM(1), 0x81,       // -127
               LOGICAL_MAXIMUM(1), 0x7f,       // 127
               REPORT_SIZE(1), 0x08,
*/
               LOGICAL_MINIMUM(2), 0x01, 0x80,       // -32767
               LOGICAL_MAXIMUM(2), 0xff, 0x7f,       // 32767
               REPORT_SIZE(1), 0x10,
               REPORT_COUNT(1), 0x02,
               INPUT(1), 0x02,                 // Data, Variable, Absolute
#if 1               
               USAGE_PAGE(1), 0x01,            // Generic Desktop
                 USAGE(1), 0x30,                 // X
                 USAGE(1), 0x31,                 // Y
//  8 bit values
 //                LOGICAL_MINIMUM(1), 0x81,       // -127
 //                LOGICAL_MAXIMUM(1), 0x7f,       // 127
 //                REPORT_SIZE(1), 0x08,
 //                REPORT_COUNT(1), 0x04,
 //                INPUT(1), 0x02,                 // Data, Variable, Absolute                  
// 16 bit values
                 LOGICAL_MINIMUM(2), 0x01, 0x80,       // -32767
                 LOGICAL_MAXIMUM(2), 0xff, 0x7f, // 32767
                 REPORT_SIZE(1), 0x10,
                 REPORT_COUNT(1), 0x02,
                 INPUT(1), 0x02,                 // Data, Variable, Absolute                
               REPORT_SIZE(1), 0x20,
               REPORT_COUNT(1), 0x01,
               INPUT(1), 0x01,                 // Constant

              USAGE_PAGE(1), 0x01,            // Generic Desktop
                 USAGE(1), 0x32,                 // Z
                 USAGE(1), 0x33,                 // RX
                 USAGE(1), 0x34,                 // RY
                 USAGE(1), 0x35,                 // Rz
                 LOGICAL_MINIMUM(2), 0x01, 0x80,       // -32767
                 LOGICAL_MAXIMUM(2), 0xff, 0x7f, // 32767
                 REPORT_SIZE(1), 0x10,
                 REPORT_COUNT(1), 0x04,
                 INPUT(1), 0x02,                 // Data, Variable, Absolute                
 
#endif            
#if (HAT4 == 1 && 0)
// 4 Position Hat Switch
               USAGE(1), 0x39,                 // Usage (Hat switch)
               LOGICAL_MINIMUM(1), 0x00,       // 0
               LOGICAL_MAXIMUM(1), 0x03,       // 3
               PHYSICAL_MINIMUM(1), 0x00,      // Physical_Minimum (0)
               PHYSICAL_MAXIMUM(2), 0x0E, 0x01, // Physical_Maximum (270)
               UNIT(1), 0x14,                  // Unit (Eng Rot:Angular Pos)                            
               REPORT_SIZE(1), 0x04,
               REPORT_COUNT(1), 0x01,
               INPUT(1), 0x02,                 // Data, Variable, Absolute               
#endif
#if (HAT8 == 1 && 0)
// 8 Position Hat Switch
               USAGE(1), 0x39,                 // Usage (Hat switch)
               LOGICAL_MINIMUM(1), 0x00,       // 0
               LOGICAL_MAXIMUM(1), 0x07,       // 7
               PHYSICAL_MINIMUM(1), 0x00,      // Physical_Minimum (0)
               PHYSICAL_MAXIMUM(2), 0x3B, 0x01, // Physical_Maximum (315)
               UNIT(1), 0x14,                  // Unit (Eng Rot:Angular Pos)                            
               REPORT_SIZE(1), 0x04,
               REPORT_COUNT(1), 0x01,
               INPUT(1), 0x02,                 // Data, Variable, Absolute               
#endif

// Padding 4 bits
//               REPORT_SIZE(1), 0x01,
//               REPORT_COUNT(1), 0x04,
//               INPUT(1), 0x01,                 // Constant


#if (BUTTONS4 == 1)
// 4 Buttons
               USAGE_PAGE(1), 0x09,            // Buttons
               USAGE_MINIMUM(1), 0x01,         // 1
               USAGE_MAXIMUM(1), 0x04,         // 4
               LOGICAL_MINIMUM(1), 0x00,       // 0
               LOGICAL_MAXIMUM(1), 0x01,       // 1
               REPORT_SIZE(1), 0x01,
               REPORT_COUNT(1), 0x04,
               UNIT_EXPONENT(1), 0x00,         // Unit_Exponent (0)
               UNIT(1), 0x00,                  // Unit (None)                                           
               INPUT(1), 0x02,                 // Data, Variable, Absolute

// Padding 4 bits
               REPORT_SIZE(1), 0x01,
               REPORT_COUNT(1), 0x04,
               INPUT(1), 0x01,                 // Constant

#endif
#if (BUTTONS8 == 1)
// 8 Buttons
               USAGE_PAGE(1), 0x09,            // Buttons
               USAGE_MINIMUM(1), 0x01,         // 1
               USAGE_MAXIMUM(1), 0x08,         // 8
               LOGICAL_MINIMUM(1), 0x00,       // 0
               LOGICAL_MAXIMUM(1), 0x01,       // 1
               REPORT_SIZE(1), 0x01,
               REPORT_COUNT(1), 0x08,
               UNIT_EXPONENT(1), 0x00,         // Unit_Exponent (0)
               UNIT(1), 0x00,                  // Unit (None)                                           
               INPUT(1), 0x02,                 // Data, Variable, Absolute
#endif

#if (BUTTONS32 == 1 && 0)
// 32 Buttons
               USAGE_PAGE(1), 0x09,            // Buttons
               USAGE_MINIMUM(1), 0x01,         // 1
               USAGE_MAXIMUM(1), 0x20,         // 32
               LOGICAL_MINIMUM(1), 0x00,       // 0
               LOGICAL_MAXIMUM(1), 0x01,       // 1
               REPORT_SIZE(1), 0x01,
               REPORT_COUNT(1), 0x20,
               UNIT_EXPONENT(1), 0x00,         // Unit_Exponent (0)
               UNIT(1), 0x00,                  // Unit (None)                                           
               INPUT(1), 0x02,                 // Data, Variable, Absolute
#endif

             END_COLLECTION(0)
      };

      reportLength = sizeof(reportDescriptor);
      return reportDescriptor;
}
