#include "mbed.h"
#include "InterruptIn.h"
#include "SoftPwmOut.h"

SoftPwmOut::SoftPwmOut(PinName pin) : _outPin(pin) // Constructor definition. Assign _out
{
    _interval = 0.1; // Default fequency
    _width = 0;
    start(); 
}

float SoftPwmOut::read()
{
    return _width / _interval;    
}

void SoftPwmOut::write(float duty)
{
    _width = _interval * duty;
    if ( duty <= 0.0 ) _width =  0.0;
    if ( duty > 1.0 )  _width =  _interval;
}

void SoftPwmOut::start()
{
    _ticker.attach(this,&SoftPwmOut::TickerInterrupt,_interval);
}

void SoftPwmOut::stop()
{
    _ticker.detach();
    //wait(width);
}

void SoftPwmOut::period(float period)
{
    _interval = period;
    start();
}

void SoftPwmOut::period_ms(int period)
{
    SoftPwmOut::period((float)period / 1000);
    start();
}

void SoftPwmOut::period_us(int period)
{
    SoftPwmOut::period((float)period / 1000000);
    start();
}

void SoftPwmOut::pulsewidth(float width)
{
   _width = width;
   if ( _width < 0.0 ) _width = 0.0;
   if ( _width > _interval) _width = _interval;
}

void SoftPwmOut::pulsewidth_ms(int width)
{
    SoftPwmOut::pulsewidth((float)width / 1000);
}

void SoftPwmOut::pulsewidth_us(int width)
{
    SoftPwmOut::pulsewidth((float)width / 1000000);
}

void SoftPwmOut::TickerInterrupt()
{
    _outPin = 0;
    if ( _width <= 0 ) return;
    _timeout.attach(this,&SoftPwmOut::end,_width);   
}

void SoftPwmOut::end()
{  
    _outPin = 1;
//    _timeout.detach();
}
;

