

/*
 *
 * Pointy48
 *
 * created with FontCreator
 * written by F. Maximilian Thiele
 *
 * http://www.apetech.de/fontCreator
 * me@apetech.de
 *
 * File Name           : Pointy48.h
 * Date                : 05.01.2016
 * Font size in bytes  : 25319
 * Font width          : 10
 * Font height         : 47
 * Font first char     : 32
 * Font last char      : 59
 * Font used chars     : 27
 *
 * The font data are defined as
 *
 * struct _FONT_ {
 *     uint16_t   font_Size_in_Bytes_over_all_included_Size_it_self;
 *     uint8_t    font_Width_in_Pixel_for_fixed_drawing;
 *     uint8_t    font_Height_in_Pixel_for_all_characters;
 *     unit8_t    font_First_Char;
 *     uint8_t    font_Char_Count;
 *
 *     uint8_t    font_Char_Widths[font_Last_Char - font_First_Char +1];
 *                  // for each character the separate width in pixels,
 *                  // characters < 128 have an implicit virtual right empty row
 *
 *     uint8_t    font_data[];
 *                  // bit field of all characters
 */

#ifndef POINTY48_H
#define POINTY48_H

#define POINTY48_WIDTH 10
#define POINTY48_HEIGHT 47

unsigned int Pointy48[] = {
    0x62, 0xE7, // size
    0x0A, // width
    0x2F, // height
    0x20, // first char
    0x1B, // char count
    
    // char widths
    0x00, 0x0D, 0x0F, 0x1B, 0x19, 0x29, 0x1F, 0x07, 0x0E, 0x0C, 
    0x10, 0x18, 0x09, 0x11, 0x09, 0x0F, 0x19, 0x11, 0x18, 0x1A, 
    0x1B, 0x1A, 0x1B, 0x1B, 0x1B, 0x1A, 0x0B, 
    
    // font data
    0xF0, 0x10, 0x10, 0x10, 0x10, 0x08, 0x08, 0x18, 0x08, 0xF8, 0xF0, 0x40, 0xC0, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0xFE, 0xFF, 0x07, 0xFF, 0x1F, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xBB, 0xFD, 0x0F, 0x00, 0x00, 0xC0, 0x27, 0x24, 0x2E, 0x1E, 0x3E, 0xFF, 0x7C, 0xDF, 0x0F, 0x00, 0x00, 0x00, 0x01, 0x02, 0x04, 0x08, 0x18, 0x38, 0x3E, 0x3F, 0x1A, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 33
    0xE0, 0x10, 0x10, 0x30, 0xC0, 0x80, 0x00, 0xC0, 0x20, 0x10, 0x10, 0x20, 0xC0, 0x80, 0x00, 0x3F, 0xC0, 0xE0, 0xFD, 0xFA, 0x6F, 0x1F, 0x07, 0x78, 0xC0, 0xC0, 0xF8, 0xDF, 0x7D, 0x1E, 0x00, 0x00, 0x00, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 34
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x30, 0x10, 0x90, 0xF0, 0xA0, 0x40, 0xC0, 0x20, 0x20, 0x20, 0xA0, 0xE0, 0x40, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x78, 0x18, 0x18, 0x08, 0x18, 0x07, 0x00, 0x00, 0x08, 0x0F, 0x0F, 0x0D, 0x0F, 0x03, 0x00, 0x00, 0x18, 0x1F, 0x1F, 0xFF, 0x7F, 0xAF, 0xE0, 0x80, 0x00, 0xE0, 0x11, 0x23, 0x37, 0x3F, 0x07, 0x00, 0x00, 0x78, 0x7F, 0x7B, 0x7F, 0x49, 0x3F, 0x10, 0x00, 0x00, 0x30, 0x3F, 0x3A, 0xB6, 0x7B, 0xCF, 0x8F, 0x03, 0x00, 0x06, 0x0D, 0x3C, 0xFC, 0x1C, 0x00, 0x00, 0xC0, 0xFC, 0xF8, 0xF8, 0xF8, 0x1C, 0x00, 0x00, 0x00, 0xE0, 0xFC, 0x58, 0xFC, 0x2C, 0x7F, 0x7F, 0x3F, 0x3F, 0x3F, 0x00, 0x00, 0x00, 0x07, 0x0E, 0x1F, 0x1A, 0x1E, 0x3F, 0x3D, 0x3F, 0x0F, 0x0D, 0x1E, 0x3E, 0x22, 0x3E, 0x3F, 0x3D, 0x3F, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 35
    0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x40, 0x7C, 0x44, 0x04, 0x04, 0x04, 0x7C, 0xF8, 0xE8, 0xF0, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x08, 0x06, 0x02, 0x01, 0x00, 0x60, 0xF0, 0xF8, 0xF8, 0x00, 0x00, 0xFC, 0x08, 0xF8, 0xD0, 0xE1, 0xE1, 0x63, 0xBF, 0xFE, 0xFC, 0xF8, 0x40, 0x00, 0x01, 0x06, 0x08, 0x10, 0x20, 0x40, 0x40, 0x80, 0x81, 0x01, 0x00, 0x00, 0x03, 0x03, 0x07, 0x0F, 0x0F, 0x10, 0x21, 0xE1, 0xC1, 0x80, 0x00, 0x00, 0x00, 0x00, 0x40, 0xA0, 0x10, 0x08, 0x0C, 0x18, 0x38, 0x31, 0x3E, 0x00, 0x00, 0x00, 0x7F, 0x5F, 0x3E, 0x1C, 0x00, 0x00, 0xC0, 0x3F, 0xDF, 0x6D, 0xF6, 0xF8, 0x00, 0x00, 0x01, 0x02, 0x04, 0x04, 0x08, 0x08, 0x68, 0x90, 0x80, 0x80, 0xC0, 0xB8, 0x7C, 0xFC, 0xFC, 0x3E, 0x3B, 0x3E, 0x3F, 0x1D, 0x1F, 0x0F, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x0E, 0x0E, 0x1E, 0x1E, 0x1E, 0x1E, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 36
    0x00, 0x00, 0x80, 0xC0, 0x60, 0x30, 0x10, 0x10, 0x10, 0x18, 0x18, 0x10, 0x30, 0x60, 0xC0, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x80, 0xC0, 0x78, 0x10, 0x0C, 0x0C, 0x1C, 0x18, 0xF0, 0xE0, 0xC0, 0xC0, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x06, 0x01, 0x00, 0x00, 0x3C, 0xFA, 0xFD, 0xFF, 0xED, 0x6B, 0x3E, 0x00, 0x80, 0x60, 0xFF, 0xFD, 0xF7, 0xFE, 0x3C, 0x1E, 0x07, 0x01, 0x00, 0x80, 0xE0, 0xF0, 0x7C, 0xFF, 0xFF, 0xFF, 0x73, 0x1F, 0x07, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x04, 0x04, 0x08, 0x18, 0x18, 0x38, 0x7C, 0x7C, 0x76, 0x7B, 0xFD, 0x7F, 0x1F, 0x07, 0x03, 0x00, 0x80, 0xC0, 0xF0, 0xFC, 0xEE, 0xF7, 0xBF, 0xF4, 0x7F, 0x4F, 0x23, 0x21, 0x20, 0x20, 0x60, 0xC0, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x60, 0x18, 0x04, 0x03, 0x01, 0x80, 0xE0, 0xF0, 0xFC, 0xFE, 0xD7, 0xBD, 0xCF, 0xFB, 0x7F, 0x07, 0x01, 0xF0, 0xFC, 0xFE, 0xFE, 0xBE, 0xFE, 0x7C, 0x00, 0x00, 0x03, 0xFF, 0x7C, 0xD8, 0xF0, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x0B, 0x18, 0xB8, 0x70, 0x38, 0x7C, 0x7F, 0x47, 0xF3, 0xBD, 0xFB, 0x3D, 0x1F, 0x06, 0x03, 0x01, 0x07, 0x0C, 0x18, 0x30, 0x31, 0x63, 0xE1, 0xF1, 0xF0, 0xF8, 0xB8, 0xFC, 0xFF, 0xFB, 0x7D, 0x3F, 0x1F, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 37
    0x00, 0x00, 0x00, 0xC0, 0x30, 0x08, 0x08, 0x04, 0x02, 0x82, 0xC1, 0xC1, 0xA1, 0xA1, 0xC1, 0xC1, 0x02, 0x02, 0x06, 0x0C, 0x3C, 0xF0, 0xE0, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x18, 0xA0, 0xC0, 0x00, 0x00, 0x0F, 0x0F, 0x1F, 0x1F, 0x1F, 0x0F, 0x03, 0x00, 0x80, 0xC0, 0xE0, 0xF8, 0x67, 0xF9, 0xEF, 0xFF, 0x3C, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE0, 0x18, 0x04, 0x02, 0x01, 0x81, 0xE0, 0xF0, 0xB0, 0xD8, 0xF8, 0xA0, 0x40, 0x80, 0x00, 0x01, 0x03, 0x04, 0x0F, 0x1F, 0x3F, 0x1F, 0x0E, 0x07, 0x06, 0x0C, 0xD8, 0x70, 0x60, 0xC0, 0x80, 0x1F, 0x20, 0x40, 0x80, 0x80, 0x07, 0x0F, 0x0F, 0x0F, 0x0F, 0x09, 0x10, 0x08, 0x08, 0x09, 0x06, 0x80, 0xC0, 0xE0, 0x40, 0xC0, 0x80, 0x00, 0x04, 0x06, 0x0B, 0x9D, 0xFF, 0xAE, 0xC3, 0xC1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x03, 0x07, 0x06, 0x0E, 0x0F, 0x1E, 0x3E, 0x3E, 0x3B, 0x1F, 0x1D, 0x1F, 0x1E, 0x0F, 0x0D, 0x06, 0x03, 0x02, 0x06, 0x0F, 0x1F, 0x3B, 0x1E, 0x0F, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 38
    0xF0, 0x08, 0x08, 0x08, 0xF0, 0xC0, 0x80, 0x0F, 0x18, 0x30, 0x3F, 0x76, 0x0B, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 39
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x60, 0xA0, 0xC0, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x30, 0x0C, 0x02, 0xC1, 0xE0, 0xF0, 0xF8, 0xF8, 0xFF, 0xFD, 0x7E, 0x00, 0xFE, 0x01, 0x00, 0xF8, 0xEF, 0xF7, 0xBE, 0xFF, 0x1D, 0x02, 0x01, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x1F, 0x66, 0xBB, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x1C, 0x20, 0xC0, 0x00, 0x03, 0x0F, 0x1B, 0xFC, 0xF0, 0xA0, 0xC0, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x04, 0x18, 0x30, 0x3E, 0x3E, 0x7E, 0xFE, 0xFE, 0x80, // 40
    0xE0, 0x40, 0xC0, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x38, 0x70, 0xC1, 0x83, 0x06, 0x18, 0x70, 0xC0, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x0F, 0xF0, 0x00, 0x1F, 0xEF, 0xFE, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x80, 0x60, 0x1F, 0x00, 0xE0, 0xDF, 0xFF, 0xFF, 0xF0, 0x88, 0x0C, 0x86, 0xC3, 0xE0, 0x30, 0xFC, 0x37, 0xFF, 0x7F, 0x07, 0x0E, 0x3E, 0xFE, 0xE2, 0x7C, 0x3A, 0x1E, 0x08, 0x06, 0x02, 0x00, 0x00, // 41
    0x80, 0x80, 0x80, 0x80, 0xF8, 0x08, 0x10, 0x10, 0xF0, 0xE0, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF8, 0x10, 0x10, 0x00, 0xC0, 0xC0, 0x81, 0x08, 0x18, 0x78, 0xF9, 0xFF, 0x3A, 0x3C, 0x08, 0x00, 0x00, 0x01, 0x02, 0x07, 0x0E, 0x0F, 0x07, 0x03, 0x02, 0x07, 0x0F, 0x0F, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 42
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x03, 0x03, 0x02, 0x03, 0x03, 0xFE, 0xA4, 0xD8, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7E, 0xFA, 0xC2, 0xC2, 0x82, 0xC2, 0x81, 0xC3, 0x80, 0x00, 0x00, 0x00, 0x00, 0xC1, 0xC1, 0xC1, 0xC1, 0xC2, 0xC2, 0x41, 0xFA, 0xEE, 0x44, 0xF8, 0x00, 0x00, 0x00, 0x01, 0x01, 0x03, 0x02, 0x03, 0xFF, 0xC0, 0xC0, 0xC0, 0xC0, 0xFF, 0x77, 0xAF, 0xFF, 0xFF, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x03, 0x07, 0x07, 0x07, 0x03, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 43
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x46, 0xE2, 0x06, 0x04, 0xAC, 0xD8, 0xB0, 0xC0, 0x00, 0x0C, 0x1A, 0x1C, 0x3A, 0x3C, 0x1E, 0x1E, 0x06, // 44
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x40, 0x80, 0x00, 0x03, 0x04, 0x0C, 0x1C, 0x1C, 0x14, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x14, 0x1C, 0x17, 0x1E, 0x1F, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 45
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x40, 0x40, 0x40, 0x40, 0x80, 0x00, 0x00, 0x00, 0x0F, 0x10, 0x10, 0x30, 0x6C, 0x7B, 0x7D, 0x5E, 0x3C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 46
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x08, 0x04, 0x08, 0x88, 0xF8, 0xB0, 0x60, 0x80, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x0F, 0x00, 0x00, 0x00, 0xF8, 0xFF, 0xFB, 0xFF, 0xFF, 0x3F, 0x00, 0x00, 0xF0, 0x0F, 0x00, 0x00, 0x00, 0xE0, 0xFF, 0x01, 0xFF, 0xFF, 0x3F, 0x03, 0x00, 0xC0, 0x3E, 0x01, 0x00, 0x00, 0xC0, 0xFE, 0xFF, 0xF1, 0xEF, 0x3C, 0x03, 0x00, 0x00, 0x00, 0x03, 0x06, 0x0E, 0x1E, 0x3E, 0x3F, 0x3D, 0x3E, 0x3F, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 47
    0x00, 0x00, 0xC0, 0x20, 0x10, 0x10, 0x08, 0x08, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x08, 0x08, 0x10, 0x20, 0x60, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x03, 0x00, 0x00, 0x00, 0xC0, 0xFC, 0xBE, 0xD6, 0xFA, 0xFF, 0x3E, 0x3E, 0x1E, 0x3C, 0xF0, 0x00, 0x00, 0x00, 0x01, 0xFF, 0xE6, 0xFC, 0xF0, 0xC0, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFD, 0x1F, 0xFE, 0x03, 0x00, 0x00, 0x00, 0xF8, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xCF, 0xF3, 0xFF, 0x07, 0x38, 0xF8, 0xC0, 0x80, 0x01, 0x0F, 0x0F, 0x1C, 0x17, 0x18, 0x18, 0x0C, 0x0F, 0x03, 0x00, 0x00, 0xA0, 0xE0, 0x3C, 0xFF, 0xFF, 0xFF, 0xFE, 0x3F, 0x00, 0x00, 0x00, 0x01, 0x03, 0x03, 0x07, 0x06, 0x06, 0x0C, 0x2C, 0x3C, 0x3C, 0x3C, 0x32, 0x3E, 0x1F, 0x17, 0x1A, 0x17, 0x0F, 0x07, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 48
    0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0xE0, 0x30, 0x18, 0x0C, 0x06, 0x3F, 0xFE, 0xFC, 0xF8, 0xE0, 0xC0, 0x30, 0x30, 0x6C, 0xE6, 0xE3, 0xE1, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xDD, 0xF7, 0xFE, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x01, 0x03, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x7F, 0xF3, 0x3F, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE0, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFB, 0xFC, 0xCF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x06, 0x06, 0x06, 0x0E, 0x1E, 0x1E, 0x37, 0x16, 0x1F, 0x1F, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 49
    0x00, 0xC0, 0xF0, 0x30, 0x18, 0x08, 0x0C, 0x84, 0x84, 0xC6, 0xC2, 0xC2, 0x86, 0x04, 0x04, 0x04, 0x08, 0x18, 0x30, 0xE0, 0xC0, 0x80, 0x00, 0x00, 0x0E, 0x0F, 0x1D, 0x3C, 0x3C, 0x7C, 0x7C, 0x7F, 0x7F, 0x7D, 0x7F, 0x06, 0x87, 0xE7, 0xBE, 0x00, 0x00, 0x00, 0x00, 0xC0, 0xFF, 0xFF, 0xFE, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xC0, 0x60, 0x30, 0x1C, 0x07, 0x03, 0x00, 0x80, 0xC0, 0x70, 0xFC, 0x7F, 0xAB, 0x77, 0x3D, 0x0F, 0x03, 0x00, 0xC0, 0x60, 0x18, 0x0C, 0x06, 0x01, 0x00, 0x00, 0x00, 0x08, 0x0C, 0x06, 0x07, 0x07, 0x07, 0x07, 0x06, 0x0F, 0xCF, 0xFC, 0xF8, 0xF0, 0xE0, 0x01, 0x03, 0x07, 0x0F, 0x0F, 0x1F, 0x3E, 0x2E, 0x36, 0x2E, 0x36, 0x3E, 0x3E, 0x3A, 0x3A, 0x36, 0x3A, 0x3A, 0x3E, 0x3F, 0x3F, 0x13, 0x3F, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 50
    0x00, 0x00, 0x00, 0x80, 0x40, 0x20, 0x10, 0x10, 0x08, 0x08, 0x84, 0x04, 0x04, 0x04, 0x04, 0x04, 0x08, 0x18, 0x30, 0xE0, 0xC0, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x1F, 0x39, 0x78, 0xF8, 0xD8, 0xBE, 0xBF, 0xFB, 0xBF, 0x5F, 0x7F, 0x3F, 0x1C, 0x00, 0x80, 0x00, 0x80, 0xC1, 0xFF, 0x5F, 0xF7, 0xDC, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x30, 0x30, 0x70, 0xF0, 0xF0, 0xE0, 0x01, 0x03, 0x07, 0x0F, 0x3F, 0xFD, 0xE7, 0xC7, 0x01, 0x00, 0x04, 0x3A, 0xC2, 0x02, 0x02, 0x02, 0x02, 0x0E, 0x18, 0x18, 0x30, 0x30, 0x30, 0x28, 0x1D, 0x07, 0x00, 0x00, 0x80, 0xC0, 0xF8, 0xFF, 0xFE, 0xBF, 0xFF, 0xFE, 0x00, 0x00, 0x00, 0x01, 0x03, 0x02, 0x06, 0x0C, 0x1C, 0x1C, 0x3C, 0x3C, 0x6C, 0x7C, 0x7E, 0x7E, 0x7E, 0x3F, 0x3F, 0x3F, 0x1F, 0x1F, 0x0E, 0x07, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 51
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xC0, 0x60, 0x30, 0x08, 0xFC, 0xF8, 0xD0, 0xE0, 0xC0, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0xE0, 0x38, 0x1C, 0x06, 0x03, 0x81, 0x80, 0x00, 0x00, 0x01, 0xFF, 0xFD, 0xFF, 0x5F, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x70, 0x38, 0x0E, 0x07, 0x01, 0xC0, 0xE0, 0xF8, 0xBC, 0xEF, 0xFF, 0x7F, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFD, 0xDE, 0xFF, 0xC0, 0xC0, 0x80, 0x00, 0x3E, 0x37, 0x71, 0x50, 0xF0, 0xF0, 0xB0, 0xF1, 0xF1, 0xF1, 0xF1, 0xD1, 0xF0, 0xF1, 0xF0, 0x00, 0x00, 0x00, 0xF0, 0xF0, 0xF8, 0xF0, 0xFF, 0x4F, 0x72, 0x79, 0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0F, 0x1F, 0x3C, 0x3E, 0x1E, 0x1F, 0x1F, 0x2F, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 52
    0x40, 0x40, 0xE0, 0x60, 0x40, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x10, 0xF0, 0xF0, 0xE0, 0xC0, 0x80, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xF8, 0xD8, 0xF8, 0xF8, 0xF8, 0xB8, 0xB8, 0xB8, 0xB8, 0x3C, 0x3C, 0x3F, 0x3F, 0x3D, 0x1F, 0x3F, 0x20, 0x00, 0x00, 0x00, 0x1F, 0x10, 0x10, 0x38, 0x38, 0x58, 0x78, 0x68, 0x78, 0x78, 0x70, 0xB0, 0xE0, 0xE1, 0x81, 0x01, 0x03, 0x06, 0x0E, 0x3C, 0xF8, 0xF0, 0xE0, 0xC0, 0x00, 0x10, 0x70, 0x90, 0x18, 0x10, 0x08, 0x08, 0x30, 0x20, 0x20, 0x20, 0x20, 0x30, 0x18, 0x0F, 0x07, 0x00, 0x00, 0x80, 0xC0, 0x78, 0xFF, 0xF7, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x01, 0x03, 0x02, 0x06, 0x06, 0x0C, 0x0C, 0x1C, 0x38, 0x1A, 0x1C, 0x3C, 0x3C, 0x3E, 0x3E, 0x37, 0x1F, 0x1F, 0x0D, 0x07, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 53
    0x00, 0x00, 0x00, 0x80, 0x60, 0x10, 0x08, 0x08, 0x0C, 0x04, 0x04, 0x04, 0x04, 0x0C, 0x0C, 0x08, 0x08, 0x18, 0x30, 0x70, 0xE0, 0xC0, 0x80, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x1C, 0x03, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xFE, 0xFE, 0xFE, 0xFE, 0xFA, 0x1E, 0x1E, 0x0C, 0x1C, 0x18, 0x38, 0x3C, 0x7C, 0xFF, 0x7B, 0x6F, 0x3E, 0x1C, 0x08, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x81, 0xC1, 0xE1, 0xE1, 0x61, 0xE1, 0xE1, 0xC3, 0x82, 0x02, 0x04, 0x0C, 0x18, 0x70, 0xE0, 0xC0, 0xC0, 0x00, 0x00, 0x00, 0x07, 0x78, 0x80, 0x00, 0x00, 0x00, 0x03, 0x0F, 0x1F, 0x3D, 0x7F, 0x67, 0x61, 0x21, 0x31, 0x1F, 0x0F, 0x00, 0x00, 0x80, 0xE0, 0x9F, 0xC3, 0xBF, 0xFF, 0xFE, 0x08, 0x00, 0x00, 0x00, 0x01, 0x01, 0x02, 0x02, 0x04, 0x04, 0x08, 0x08, 0x18, 0x18, 0x38, 0x38, 0x38, 0x34, 0x3E, 0x3B, 0x3F, 0x3C, 0x3B, 0x1F, 0x0F, 0x07, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 54
    0xE0, 0xE0, 0x20, 0x30, 0x10, 0x10, 0x10, 0x10, 0x18, 0x18, 0x18, 0x18, 0x18, 0x38, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0xD8, 0xF8, 0xF0, 0xC0, 0xC0, 0x80, 0x00, 0x1F, 0x1F, 0x1C, 0x38, 0x78, 0x78, 0xF8, 0xF8, 0xF8, 0xFC, 0x3C, 0x0C, 0x04, 0x00, 0x00, 0x00, 0xC0, 0xF0, 0xFC, 0xFF, 0xFF, 0x7F, 0x9D, 0x77, 0x1A, 0x05, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xF8, 0x3F, 0x07, 0x01, 0x00, 0x00, 0xC0, 0xF8, 0xFF, 0xF7, 0x7F, 0xCF, 0xFE, 0x73, 0x1F, 0x07, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x3F, 0x03, 0x00, 0x00, 0x00, 0xE0, 0xFC, 0xFF, 0xBF, 0xFF, 0xE7, 0x3D, 0x06, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x07, 0x07, 0x0F, 0x1F, 0x3B, 0x37, 0x3E, 0x3F, 0x39, 0x0F, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 55
    0x00, 0x00, 0x80, 0xC0, 0xC0, 0x60, 0x30, 0x30, 0x10, 0x90, 0x88, 0x88, 0x88, 0x08, 0x08, 0x08, 0x10, 0x10, 0x20, 0xC0, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x1B, 0x3F, 0x3F, 0x3F, 0x1F, 0x0F, 0x00, 0x00, 0x00, 0xC0, 0xF0, 0xDF, 0x73, 0x9E, 0xEC, 0xF0, 0x00, 0x00, 0xF0, 0x3C, 0x0E, 0x07, 0x03, 0x02, 0xC0, 0x60, 0xF0, 0xF0, 0xD8, 0xB0, 0xF0, 0xF0, 0xE0, 0xC0, 0x01, 0x03, 0x03, 0x07, 0x0F, 0x3F, 0xEF, 0x46, 0x81, 0x00, 0x00, 0x7F, 0xE0, 0x80, 0x80, 0x00, 0x02, 0x07, 0x8D, 0x0F, 0x1F, 0x1F, 0x1F, 0x10, 0x08, 0x08, 0x07, 0x00, 0x80, 0x80, 0xC0, 0xE0, 0xB8, 0x6F, 0xDE, 0xA3, 0xFF, 0x7E, 0x00, 0x00, 0x01, 0x03, 0x03, 0x07, 0x07, 0x0F, 0x0F, 0x1F, 0x3F, 0x37, 0x3F, 0x3F, 0x3F, 0x3F, 0x37, 0x3F, 0x3F, 0x3C, 0x3F, 0x1D, 0x0F, 0x0F, 0x07, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 56
    0x00, 0x00, 0x00, 0xC0, 0x40, 0x20, 0x10, 0x10, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x10, 0x10, 0x30, 0x60, 0xE0, 0xC0, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x0E, 0x01, 0x00, 0x00, 0xE0, 0xF0, 0xF8, 0xF8, 0xFC, 0xF4, 0x7C, 0x7C, 0xF8, 0x80, 0x00, 0x00, 0x00, 0x01, 0x0F, 0xFB, 0xEF, 0xBE, 0xFC, 0xF0, 0xE0, 0x07, 0x38, 0x40, 0x80, 0x00, 0x00, 0x03, 0x07, 0x0F, 0x0F, 0x0F, 0x04, 0x86, 0x43, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xBF, 0xFF, 0xFE, 0xB7, 0xFF, 0x00, 0x30, 0xF0, 0x10, 0x19, 0x0D, 0x1A, 0x3A, 0x76, 0x77, 0x7D, 0x7F, 0x3F, 0x1F, 0x0F, 0x00, 0x00, 0x00, 0xC8, 0x7C, 0xD7, 0xFC, 0xFF, 0xFF, 0x3F, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x02, 0x04, 0x04, 0x0C, 0x08, 0x08, 0x18, 0x18, 0x18, 0x38, 0x3C, 0x3E, 0x3D, 0x3E, 0x1F, 0x1B, 0x0F, 0x07, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 57
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE0, 0x10, 0x10, 0x10, 0x18, 0x30, 0xE0, 0xC0, 0x80, 0x00, 0x00, 0x07, 0x0C, 0x18, 0x1C, 0x3C, 0x3E, 0x7D, 0x3F, 0x3F, 0x1F, 0x00, 0xC0, 0x20, 0x10, 0x10, 0x90, 0x60, 0xE0, 0xC0, 0x80, 0x00, 0x00, 0x03, 0x04, 0x0C, 0x18, 0x3C, 0x7F, 0x7F, 0x7F, 0x3F, 0x1F, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 // 58
    
};

#endif

