#include "mbed.h"
#include "C12832.h"


// Led
BusOut LEDS(LED1,LED2,LED3,LED4);

// Joystick
InterruptIn center(p14);

class IsA : public BusOut
{
void LedOff();
void LedOn();
void LedOn(int HexOut);
void Ein();
void Aus();
};


void LedOn()
{
    LEDS = 1;
}

void LedOff()
{
    LEDS = 0;
}

void Ein()
{
    while(1)
    {
         LEDS = 3;
        {
            return;
        }
    }
}

void Aus()
{
    
}

class IsAnEvent : public InterruptIn {
        volatile int16_t _pressed;
        void _RisingISR(); 
    public:
        IsAnEvent() : InterruptIn(p14) {};
        IsAnEvent(PinName pin) : InterruptIn(pin) {
             rise(callback(this, &IsAnEvent::_RisingISR)); 
            _pressed=0; 
        };
        int CheckFlag();
        void InitIsr();
};

void IsAnEvent::InitIsr() { 
    rise(callback(this, &IsAnEvent::_RisingISR)); 
}

void IsAnEvent::_RisingISR() {
    wait_ms(500);
    if( read() )
        _pressed = true;
}
int IsAnEvent::CheckFlag() {
    if( _pressed ) { 
        _pressed = false; 
        return 1; 
    }
    return 0;

}

int main() 
{
    LedOn();
    wait_ms(500);
    LedOff();
    Ein();
}