/** Serial port handler.
 * Copyright (c) 2015 Gabriel Rivas
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "SerialPortHandler.h"

SerialPortHandler::SerialPortHandler(Serial* ps, MessageQueue<uint8_t>* txQueue, MessageQueue<uint8_t>* rxQueue)
{
    //assert(ps != NULL);
    m_ps = ps;
    //assert(txQueue != NULL);
    m_txQueue = txQueue;
    //assert(rxQueue != NULL);
    m_rxQueue = rxQueue;
}

SerialPortHandler::~SerialPortHandler()
{
    delete m_ps;
    delete m_txQueue;
    delete m_rxQueue;
}

void SerialPortHandler::transmitPacket()
{
    uint32_t count = m_txQueue->getWriteIndex();
    uint8_t data;

    for (uint32_t i = 0; i < count; i++) {
        data = m_txQueue->read();

        m_ps->putc(data);
    }
}

void SerialPortHandler::receivePacket()
{
    uint8_t rxreg = m_ps->getc();
    m_rxQueue->write(rxreg);
}
