/******************************* motor.h *********************************/
/* Version: 1.0                                                          */
/* Last Updated: June 1, 2013                                            */
/*                                                                       */
/* The motor class is used for motor control using a PWM ECS. When a     */
/*a motor object is created you must pass the PWM pin as the only        */
/*argument.                                                              */
/*                                                                       */
/*  Wiring diagrams                                                      */
/*                 _______                     _______                   */
/*       CW   ----|       |     CCW   ---\/ --|       |                  */
/*            ----| Motor |           ---/\---| Motor |                  */
/*            ----|_______|           --/  \--|_______|                  */
/*            Straight through       Switch wire 1 and 3                 */
/*                                                                       */
/*************************************************************************/

  
#ifndef MOTOR_H
#define MOTOR_H

#include "mbed.h"

class motor
{   
    public:
        motor( PinName );           // motor object constructor.
        void setSpeed( int );       // Set the speed for the motor 0-100
        void setPulseMin( float );  // Set smallest pulse.
        void setPulseMax( float );  // Set largest pulse.
        int getSpeed();
    
    private:   
        PwmOut *pwmPin;             // Pin used for PWM.
        int currentSpeed;           // Speed of the motor.
        float pulse;                // Current pulse of the motor.
        float pulseMin;             // Shortest value for the pulse
        float pulseMax;             // Largest value for the pulse.
};

#endif