#include "mbed.h"
#include <math.h>

#include <MQTTClientMbedOs.h>
#include "SpwfSAInterface.h"


#include "XNucleoIKS01A2.h"

#define MQTT_MAX_PACKET_SIZE 250   
#define MQTT_MAX_PAYLOAD_SIZE 300

SpwfSAInterface wifi(MBED_CONF_APP_WIFI_TX, MBED_CONF_APP_WIFI_RX);

static XNucleoIKS01A2 *mems_expansion_board = XNucleoIKS01A2::instance(D14, D15, D4, D5);
static LSM6DSLSensor *acc_gyro = mems_expansion_board->acc_gyro;

int main()
{
    uint8_t id;
    int16_t axes[3];
    int32_t axes_gyro[3];
    acc_gyro->enable_x();
    acc_gyro->enable_g();
    acc_gyro->read_id(&id);
    acc_gyro->set_x_fs(2.0f);

    printf("MQTT Integration\n\n");

    printf("\nConnecting to %s...\n", MBED_CONF_APP_WIFI_SSID);
    int ret = wifi.connect(MBED_CONF_APP_WIFI_SSID, MBED_CONF_APP_WIFI_PASSWORD, NSAPI_SECURITY_WPA_WPA2);
    if (ret != 0) {
        printf("\nConnection error\n");
        return -1;
    }
    
    printf("Success\n\n");
    

    //NetworkInterface *net = NetworkInterface::get_default_instance();
    TCPSocket socket;
    MQTTClient client(&socket);
    socket.open(&wifi);
    int rc = socket.connect("192.168.178.21", 1883);
    
    if (rc == 0)
        printf("Connection Successful");
    else
        printf("Connection Failed");
    
    MQTTPacket_connectData data = MQTTPacket_connectData_initializer;
    
    data.MQTTVersion = 4;
    data.struct_version=0;
    data.clientID.cstring = "clientId-ACC2";
    data.username.cstring = "jlenz";
    data.password.cstring = "123";

    rc = client.connect(data);
    
    if (rc == 0)
        printf("Client Connection Successful");
    else
        printf("Client Connection Failed");
    
    while(1) 
    {
        int con = client.isConnected();
        if (con == false)
            client.connect(data);
            
        acc_gyro->get_x_axes_raw(axes);
        MQTT::Message message;
        char* pubTopic = "SLG/ACC2";
        char buf[MQTT_MAX_PAYLOAD_SIZE];
        auto normAxe = axes[0]*axes[0] + axes[1]*axes[1] + axes[2]*axes[2];
        sprintf(buf,"%d",normAxe);
        message.qos = MQTT::QOS0;
        message.retained = false;
        message.dup = false;
        message.payload = (void*)buf;
        message.payloadlen = strlen(buf);
        client.publish(pubTopic, message);
        printf("%d \n",normAxe);
        printf("%d \n",axes[0]);
        
    }




    wifi.disconnect();

    printf("\nDone\n");
}
