#include "mbed.h"
#include "TS_DISCO_F429ZI.h"
#include "LCD_DISCO_F429ZI.h"
#include "rectangle.h"
#include "config.h"
#include "button.h"
#include <vector>

using std::vector;

int main()
{
    LCD_DISCO_F429ZI LcdScreen;
    TS_DISCO_F429ZI TouchScreen;
    vector <Figure*> Figures(RECTANGLE_NR);
    vector <Widget*> Buttons(BUTTONS_NR);
    uint8_t XCoord = 0, YCoord = 0, ButtonCounter = 0;
    
    for(vector<Widget*>::iterator itWidget=Buttons.begin(); itWidget != Buttons.end(); itWidget++){
        
        char ButtonCounterStr[4];
        sprintf(ButtonCounterStr, "%u", ButtonCounter);

        *itWidget = new Button(XCoord, ((0 != YCoord) ? YCoord-1:YCoord) ,RECTANGE_WIDTH, RECTANGE_HEIGHT, ButtonCounterStr);
        YCoord += RECTANGE_HEIGHT;   
        ButtonCounter++;
    }
  
    BSP_LCD_SetFont(&Font24);    
    LcdScreen.Clear(LCD_COLOR_BLACK);
    LcdScreen.SetBackColor(LCD_COLOR_BLACK);
    uint8_t TsStatus = TouchScreen.Init(LcdScreen.GetXSize(), LcdScreen.GetYSize());
    
    while(TS_OK == TsStatus)
    {
        TS_StateTypeDef TsState;
        uint16_t XCoord = SCREEN_WIDTH+1, YCoord = SCREEN_HEIGHT+1;
        
        TouchScreen.GetState(&TsState);  
        
        for(vector<Widget*>::iterator ItWidget=Buttons.begin(); ItWidget != Buttons.end(); ItWidget++){
            
            if(TsState.TouchDetected){
                XCoord = TsState.X;
                YCoord = TsState.Y;
            } 
            
            (*ItWidget)->Check(XCoord, YCoord);
            LcdScreen << (*ItWidget)->GetFigure();
        }
        
        wait(0.1);
    }
}
