/**
 * @section LICENSE
 * This program is free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation; either version 2 of the License, or 
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License 
 * for more details.
 * 
 * You should have received a copy of the GNU General Public License along 
 * with this program; if not, write to the Free Software Foundation, Inc., 
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * @section DESCRIPTION
 * Library to interface with the SCP1000 pressure and temperature sensor.
 */

#include "SCP1000.h"

SCP1000::SCP1000(PinName mosi, PinName miso, PinName sclk, PinName cs)
    : m_spi(mosi, miso, sclk)
    , m_cs(cs) {
    m_cs=1;
    m_spi.frequency(500000); // the fastest of the sensor
    m_spi.format(8, 0); // duda son dos palabras de 8 bits? 
    wait(0.5);
    //------------------------------------------------
    // pc.printf("RESET\r\n");
    write_register(0x06,0x01);
    wait(0.5);

    // pc.printf("Initialize High Resolution Constant Reading Mode\r\n");
    write_register(0x03,0x0A);
    wait(0.5);
}

unsigned long SCP1000::readPressure() {
    unsigned long pressure_msb = read_register(PRESSURE);
    pressure_msb &= 0x07;
    unsigned long pressure_lsb = read_register16(PRESSURE_LSB);
    unsigned long pressure = ((pressure_msb<<16)| pressure_lsb);
    pressure /= 4;
    
    return pressure;
}

float SCP1000::readTemperature() {
    float temp_in = read_register16(TEMP);
    temp_in /= 20;
    return temp_in;
}

 char SCP1000::read_register(char register_name) {
    register_name <<=2;
    register_name &= 0xFC;
    m_cs=0; //Select SPI device
    m_spi.write(register_name); //Send register location
    char register_value=m_spi.write(0x00);
    m_cs=1;
    return register_value;  
}

void SCP1000::write_register(char register_name, char register_value) {
    register_name <<= 2;
    register_name |= 0x02; //le estamos diciendo que escriba
    m_cs=0; //Select SPI device
    m_spi.write(register_name); //Send register location
    m_spi.write(register_value); //Send value to record into register
    m_cs=1;
}

float SCP1000::read_register16(char register_name) {   
    register_name <<= 2;
    register_name &= 0xFC; //Read command
    m_cs=0; //Select SPI Device
    m_spi.write(register_name); //Write byte to device
    int in_byte1 = m_spi.write(0x00);    
    int in_byte2 = m_spi.write(0x00);
    m_cs=1;
    float in_word= (in_byte1<<=8) | (in_byte2);   
    return(in_word);
}