#include "lab.h"

lab::lab()
{

}

lab::~lab()
{

}

void lab::init(int x, int y, int height,int width, int speed)
{
    _x = x;  // x value on screen is fixed
    _y = y;  // y depends on height of screen and height of paddle
    _height = height;
    _width = width;  

    
    
    // default speed
    _score = 0;

        _velocity.x = speed;
        _velocity.y = speed;


}

void lab::draw(N5110 &lcd)
{
    // draw paddle in screen buffer. 
    lcd.drawRect(_x,_y,_width,_height,FILL_BLACK);
}

void lab::update(Direction d,float mag)
{
                         _velocity.x = int(mag*0.0f); 
                _velocity.y = int(mag*0.0f); 
                
                // scale is arbitrary, could be changed in future

    // update y value depending on direction of movement
    // North is decrement as origin is at the top-left so decreasing moves up
   if (d == N) {
        _y-=_velocity.y;
    } else if (d == S) {
        _y+=_velocity.y;
        }

    if (d == W) {
        _x-=_velocity.x;
    } else if (d == E) {
        _x+=_velocity.x;
        }   


    // check the y origin to ensure that the paddle doesn't go off screen
    if (_y < 1) {
        _y = 1;
    }
    if (_y > HEIGHT - _height - 1) {
        _y = HEIGHT - _height - 1;
    }
    
        if (_x < 1) {
        _x = 1;
    }
    if (_x > WIDTH - _width - 1) {
        _x = WIDTH - _width - 1;
    }
}


void lab::set_velocity(Vector2D v)
{
    _velocity.x = v.x;
    _velocity.y = v.y;
}

Vector2D lab::get_velocity()
{
    Vector2D v = {_velocity.x,_velocity.y};
    return v;
}

void lab::add_score()
{
    _score++;
}
int lab::get_score()
{
    return _score;
}

Vector2D lab::get_pos() {
    Vector2D p = {_x,_y};
    return p;    
}


