///////// pre-processor directives ////////
#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "PongEngine.h"

#define PADDLE_WIDTH 2
#define PADDLE_HEIGHT 15
#define BALL_SIZE 4
#define BALL1_SIZE 6
#define BALL_SPEED 3
#define PADDLE1_WIDTH 15 
#define PADDLE1_HEIGHT 2
#define LAB_WIDTH 3 
#define LAB_HEIGHT 35
#define CAB_WIDTH 10 
#define CAB_HEIGHT 6





/////////////// structs /////////////////
struct UserInput {
    Direction d;
    float mag;
};
/////////////// objects ///////////////
N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
Gamepad pad;
PongEngine pong;
///////////// prototypes ///////////////
void init();
void update_game(UserInput input);
void render();
void welcome();
///////////// functions ////////////////
int main()
{
    int fps = 8;  // frames per second

    init();
    welcome();
    
    render();  // draw initial frame 
    wait(1.0f/fps);  

    // game loop - read input, update the game state and render the display
    while (1) {
        pong.read_input(pad);
        pong.update(pad);
        render();
        wait(1.0f/fps);
    }
}

void init()
{
    // need to initialise LCD and Gamepad 
    lcd.init();
    pad.init();
     
    // initialise the game
    pong.init(PADDLE_WIDTH,PADDLE_HEIGHT,BALL_SIZE, BALL1_SIZE, BALL_SPEED, PADDLE1_WIDTH, PADDLE1_HEIGHT, LAB_WIDTH, LAB_HEIGHT, CAB_WIDTH, CAB_HEIGHT);

}

void render()
{
    // clear screen, re-draw and refresh
    lcd.clear();  
    pong.draw(lcd);
    lcd.refresh();
}

void welcome() {
    
lcd.printString("Weclome",25,1);
wait(1.0); 
lcd.refresh();
wait(1.0);
lcd.printString("To the", 25,2);
wait(1.0);
lcd.refresh();
lcd.printString("Labirint!",24,3);
wait(1.0);
lcd.refresh();
lcd.clear();
wait(1.0);

lcd.printString("Rules:",5,1);
wait(1.0); 
lcd.refresh();
wait(1.0);
lcd.printString("Press L", 5,2);
wait(1.0);
lcd.refresh();
lcd.printString("To get bigger",5,3);
wait(1.0);
lcd.refresh();
lcd.clear();
wait(1.0);

lcd.printString("Or",5,1);
wait(1.0); 
lcd.refresh();
wait(1.0);
lcd.printString("Press R", 5,2);
wait(1.0);
lcd.refresh();
lcd.printString("To get",5,3);
wait(1.0);
lcd.refresh();
lcd.printString("Smaller",5,4);
wait(1.0);
lcd.refresh();
lcd.clear();
wait(1.0);

lcd.printString("Small can",5,1);
wait(1.0); 
lcd.refresh();
wait(1.0);
lcd.printString("go only", 5,2);
wait(1.0);
lcd.refresh();
lcd.printString("horizontally",5,3);
wait(1.0);
lcd.refresh();
lcd.clear();
wait(1.0);

lcd.printString("Big can",5,1);
wait(1.0); 
lcd.refresh();
wait(1.0);
lcd.printString("go only", 5,2);
wait(1.0);
lcd.refresh();
lcd.printString("vertically",5,3);
wait(1.0);
lcd.refresh();
lcd.clear();
wait(1.0);

lcd.printString("You have",5,1);
wait(1.0); 
lcd.refresh();
wait(1.0);
lcd.printString("2 paddles", 5,2);
wait(1.0);
lcd.refresh();
lcd.printString("to deliver",5,3);
wait(1.0);
lcd.refresh();
lcd.clear();
wait(1.0);

lcd.printString("Ball to the",5,1);
wait(1.0); 
lcd.refresh();
wait(1.0);
lcd.printString("Home", 5,2);
wait(1.0);
lcd.refresh();
lcd.printString("Enjoy!",5,3);
wait(1.0);
lcd.refresh();
lcd.clear();
wait(1.0);

lcd.printString("Press Start",15,2);
wait(1.0);
lcd.printString("To Begin",25,4);
wait(1.0);


    lcd.refresh();
     
    // wait flashing LEDs until start button is pressed 
    while ( pad.check_event(Gamepad::START_PRESSED) == false) {
        pad.leds_on();
        wait(0.1);
        pad.leds_off();
        wait(0.1);
    }
}