#ifndef OBSTACLES_H
#define OBSTACLES_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/** Car Obstacles
*  Obstacles.h
* @brief this header file will contain all required functions used to draw the Obstacles
* @brief updating them, checking for collisions as well as tracking the score
*
* @author Ahmed Abu Zaid
*
* @date 4/5/2017
*/
class Obstacles

{

public:

    Obstacles();
    ~Obstacles();

    /**
     * init Initialises the Obstacles.
     *
     * @param seed     random number that specifies which position the obstacle shall be drawn at
     *
     * This function sets the initial values of scores and the seed for the obstacle
     */
    void init(int seed);

    /**
     *  draw draws the obstacles.
     *
     *  @param lcd      The object for the lcd screen class
     *  @param seed     random number that specifies which position the obstacle shall be drawn at
     *
     *  This function prints the obstalces in one of three positions at the top of the screen
     *  that are determined by the seed
     */

    void draw(N5110 &lcd,int seed);
    /**
     * update it updates the values of the car's coordinates
     *
     * @param lcd      The object for the lcd screen class
     *
     * This functions loops through the entire screen and stores the valuse of the pixels'
     * states, in order to shift the whole thing down
     */
    void update(N5110 &lcd);

    /**
     * add_Score it increments the value of the score
     *
     * @param lcd      The object for the lcd screen class
     *
     * This functions is called to increment the value of the score, which happens
     * when an obstacle leaves the screen from the bottom
     */
    void add_Score(N5110 &lcd);

    /**
     * reduce_Score reduces the score
     *
     * This functions is called to reduce the value of the score each time a feature is used
     * such as R/L jumps, bullet fired etc
     */
    void reduce_Score();

    /**
     * get_Score
     *
     * This functions returns the value of the adjustable score which is used in the
     * use of the features such as R/L jumps, bullet fired etc
     */
    int get_Score();

    /**
     * get_TotalScore
     *
     * This functions returns the value of the total score that is printed on the screen
     * while the game running, as well as when the game is over
     */
    int get_TotalScore();

private:

    int _Obstacle_pos_x;   // x position of obstacle
    int _score;            // adjustable score
    int _totalscore;       // total/final score
};

#endif