#include "Obstacles.h"

Obstacles::Obstacles()
{

}

Obstacles::~Obstacles()
{

}

void Obstacles::init(int seed)
{
    _Obstacle_pos_x = seed;     
    _score = 0;               // initialise scores
    _totalscore = 0;
    // printf("_Obstacle_pos_x=%d \n",_Obstacle_pos_x);
}

void Obstacles::draw(N5110 &lcd,int seed)
{
    _Obstacle_pos_x = seed;     // give a random number to the x position of the obstacle
    // printf("_Obstacle_pos_x=%d \n",_Obstacle_pos_x);
    switch(_Obstacle_pos_x) {
        case 0:
            lcd.drawRect(2,11,25,2,FILL_BLACK);  // draw in the left
            break;

        case 1:
            lcd.drawRect(28,11,27,2,FILL_BLACK);  // draw in the middle
            break;

        case 2:
            lcd.drawRect(56,11,25,2,FILL_BLACK);  // draw in the right
            break;
    }
}

void Obstacles::update(N5110 &lcd)
{
    add_Score(lcd);

    char pixelstate[82][37];              // generate an array to store pixels' values
    for (int i=1; i<83; i+=1) {
        for (int j=10; j<47; j+=1) {       // notice that we start from the 10th row as to allow enough for the
            if (lcd.getPixel(i,j)) {         // real time prints to be displayed in the first 10 rows
                pixelstate[i-1][j-10]=1;
            } else  {
                pixelstate[i-1][j-10]=0;
            }
        }
    }
    for (int i=1; i<83; i+=1) {              // loop through the array values now and then
        for (int j=10; j<47; j+=1) {                // shift all the pixels down
            if ((pixelstate[i-1][j-10]) ) {
                lcd.setPixel(i,j+2);            // pixels move in an increment of two for higher speed
            }
            if ((pixelstate[i-1][j-11]==0) ) {
                lcd.setPixel(i,j+1,false);
            }
        }
    }
}

void Obstacles::add_Score(N5110 &lcd)
{
    // loop through the last row of the screen and check if a pixel is detected
    for (int i=2; i<83; i+=1) {             // if so, then an obstacle is passing, hence break out from the loop since
        if (lcd.getPixel(i,46)) {                   // only one pixel is sufficient to prove that
            _score++;           // increase adjustable score
            _totalscore++;      // increase total/final score
            // printf("Done \n");
            break;
        }
    }
}

void Obstacles::reduce_Score()
{
    _score -= 10;     // reduce score when feature is used in other functions
}

int Obstacles::get_Score()
{
    return _score;        // adjustable score
}
int Obstacles::get_TotalScore()
{
    return _totalscore;   // total/final score
}

