#ifndef BULLET_H
#define BULLET_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/** Bullet Class
* Bullet.h
* @brief this header file will contain all required functions used to draw the bullet
* @brief and control it by directing, deleting and restricting when to be used
*
* @author Ahmed Abu Zaid
*
* @date 4/5/2017
*/
class Bullet
{

public:
    Bullet();
    ~Bullet();

    /**
    * init Initialises the bullet.
    *
    * @param CarHead     Two dimentional array containing the car head coordinates
    *
    * This function sets the values of coordinates of the bullet
    * depending on the car head coordinates
    */
    void init(Vector2D CarHead);

    /**
    * draw draws the bullet.
    *
    * @param lcd      The object for the lcd screen class
    *
    * This function prints the bullet using the lcd object, and
    * depending on the updated values of the coordinates
    */
    void draw(N5110 &lcd);

    /**
    * update it updates the values of the bullet's coordinates
    *
    * @param lcd      The object for the lcd screen class
    * @param bulletDirection    The direction of the bullet
    *
    * This functions updates the bullet's coordinates depending on the direction the bullet
    * going in which is supplied by the engine when a button is pressed
    */
    void update(N5110 &lcd,int bulletDirection);

    /**
    * clear_Bullet clears the bullet
    *
    * @param lcd      The object for the lcd screen class
    *
    * This function is used to clear the bullet before getting updated and re-drawn
    * in another place, or mybe re-initialised
    */
    void clear_Bullet(N5110 &lcd);

    /**
    * destroy_Obstacles clears obstacle when colliding with a bullet
    *
    * @param lcd      The object for the lcd screen class
    *
    * This function clears any obstacle that collides with a bullet, it loops through
    * the area of collision and clears the obstalce as well as the bullet
    */
    void destroy_Obstacles(N5110 &lcd);

private:

    // variables
    int _bullet_x;  // bullet x coordinate
    int _bullet_y;  // bullet y coordinate

};
#endif