#include "Bullet.h"

Bullet::Bullet()
{

}

Bullet::~Bullet()
{

}

void Bullet::init(Vector2D CarHead)
{
    _bullet_x =  CarHead.x;       // same x value as the car head
    _bullet_y =  CarHead.y + 2;   // starts from the square right above the car head
    // printf("x=%d y=%d \n",_bullet_x,_bullet_y);
}

void Bullet::draw(N5110 &lcd)
{
    // printf("x=%d y=%d \n",_bullet_x,_bullet_y);
    lcd.drawRect(_bullet_x,_bullet_y,2,2,FILL_BLACK);
    // printf("Crashes 0 \n");
}

void Bullet::update(N5110 &lcd,int bulletDirection)
{
    clear_Bullet(lcd);     // must clear the old bullet before updating otherwise bullets get shifted down with obstacles
    // printf("x=%d y=%d \n",_bullet_x,_bullet_y);
    if(bulletDirection==1) {
        _bullet_x = _bullet_x;           // Direction straight up
        _bullet_y = _bullet_y - 3;
    }     // steps of three

    else if(bulletDirection==2) {        // Direction diagonally left
        _bullet_x = _bullet_x - 3;
        _bullet_y = _bullet_y - 3;
    }      // steps of three

    else if(bulletDirection==3) {        // Direction diagonally right
        _bullet_x = _bullet_x + 3;
        _bullet_y = _bullet_y - 3;
    }       // steps of three

    if ((_bullet_x == -2)) {  // to avoid having _bullet_x = -1,
        clear_Bullet(lcd);
        _bullet_x = _bullet_x - 1;
        _bullet_y = _bullet_y - 1;
    }
    destroy_Obstacles(lcd);   // obstacles are destroyed if collision happens between them and bullet
}

void Bullet::clear_Bullet(N5110 &lcd)
{
    // loop through the bullet pixels
    lcd.setPixel(_bullet_x,_bullet_y,false);       // top left
    lcd.setPixel(_bullet_x,_bullet_y+1,false);     // bottom left
    lcd.setPixel(_bullet_x+1,_bullet_y,false);     // top right
    lcd.setPixel(_bullet_x+1,_bullet_y+1,false);   // bottom right
    // printf("they are x=%d y=%d \n",_bullet_x,_bullet_y);
}

void Bullet::destroy_Obstacles(N5110 &lcd)
{
    // printf("they are x=%d y=%d \n",_bullet_x,_bullet_y);            // loop through the bullet pixels and surrounding pixels
    if ((lcd.getPixel(_bullet_x,_bullet_y))     ||  // top left                     and check if any is on, so obstacle detected!
            (lcd.getPixel(_bullet_x,_bullet_y+1))    ||  // bottom left
            (lcd.getPixel(_bullet_x+1,_bullet_y))    ||  // top right
            (lcd.getPixel(_bullet_x+1,_bullet_y+1))  ||  // bottom right
            (lcd.getPixel(_bullet_x,_bullet_y-1))    ||  // up left
            (lcd.getPixel(_bullet_x+1,_bullet_y-1))  ||  // up right
            (lcd.getPixel(_bullet_x,_bullet_y+2))    ||  // down left
            (lcd.getPixel(_bullet_x+1,_bullet_y+2)))   { // down right

        for (int i=1; i<83; i+=1) {
            for (int j=_bullet_y-4; j<_bullet_y+5; j+=1) {
                lcd.setPixel(i,j,false);   // loop through and set off pixels in and surround that obstacle
            }                             // we covered wider area than obstacle's width since it
        }                                 // moves down by more than one increment!

        _bullet_x = -10;   // send it away by setting the coordinates of the bullet out of the screen
        _bullet_y = -10;   // so it won't be drawn again until re-initialise the bullet's coordinates
    }
}