/**
@file main.cpp
@brief car parking senser 
@brief Shows examples of creating Doxygen documentation.
@brief Revision 1.0.
@author Dawood Al kalbani
@date  5 May 2015
*/

#include "mbed.h"
#include "N5110.h"
#include "SRF02.h"
#include "PowerControl/PowerControl.h"
#include "PowerControl/EthernetPowerControl.h"
#include "beep.h"
#define USR_POWERDOWN  (0x104)

int semihost_powerdown() ///Function
{

    uint32_t arg;
    return __semihost (USR_POWERDOWN, &arg);
}



//    VCC,SCE,RST,D/C,MOSI,SCLK,LED
/// N5110 LCD pins
N5110 screen(p7,p8,p9,p10,p11,p13,p26);
// Can also power (VCC) directly from VOUT (3.3 V) -
// Can give better performance due to current limitation from GPIO pin
/// SRF02 output pins
SRF02 sensor(p28,p27);
//PwmOut buzz(p21);
BusOut LED(p24);
/// AnalogIn poten output pin
AnalogIn Poten(p20);
Beep buzzer(p21);

Ticker buzzerTimer; ///Ticker
int buzzerCounterMax; ///buzzer

/// this is the buzzer toggle
/// buzzerCounter - static int used to ...
void buzzerToggle(){
    static int buzzerCounter=0;
    buzzerCounter = (buzzerCounter>=buzzerCounterMax)?0:buzzerCounter+1;
    if ((buzzerCounter==0)&&(buzzerCounterMax!=0)){
        buzzer.beep(1000,0.1);
        
        }
    }

InterruptIn startReading (p15); ///InterruptIn

int startFlag = 0; ///flag
void startRead();
/// this is the startRead
void startRead()
{
    startFlag = 1;   
}    

/// this is the main
int main()
{

    int result = semihost_powerdown(); ///
    buzzerTimer.attach(&buzzerToggle,0.01);
    // first need to initialise display
    screen.init();
    // buzzer = 0.0;
    screen.printString("Leeds Uni",15,0);
    wait(1);
    screen.printString("Dawood",20,1);
    wait(1);
    screen.printString("Al Kalbani",15,2);
    wait(1);
    screen.printString("200744793",20,3);
    wait(1);
    screen.refresh();
    screen.clear();
    //button function


startReading.rise(&startRead);

    while(1) 
    {
        if (startFlag)
        
        {
            //startFlag = 0;

            //read sensor distance in cm and print over serial port
            int distance = sensor.getDistanceCm();
            //serial.printf("Distance = %d cm\n",distance);
            // short delay before next measurement

            char buffer[14];  // each character is 6 pixels wide, screen is 84 pixels (84/6 = 14)
            // so can display a string of a maximum 14 characters in length
            // or create formatted strings - ensure they aren't more than 14 characters long

            int length = sprintf(buffer,"Dist = %2d cm",distance); // print formatted data to buffer
            // it is important the format specifier ensures the length will fit in the buffer

            if (length <= 14)  // if string will fit on display
            screen.printString(buffer,0,1);           // display on screen
            
            screen.printString("Car reversing",6,2);
            
            screen.refresh();
            if(distance < 50) 
            {
                // buzz = 1.0;
//             buzz.period_ms(10);
            }
             else {
            //buzz = 0.0;

            }
            if(distance < 50) {
                LED = 1.0;
            } 
            else 
            {
                LED = 0.0;
            }

            float sound = 250 - distance; /// measure the distance withe the max limite
            float frequency = sound *2; /// the frequency of sound
            float period = distance; /// measured distance

            if ( distance < 80 ) 
            {
                if(frequency < 80)
                frequency = 0;
            //buzzer.beep(1000,0.1);
             buzzerCounterMax = distance;
            //wait(period);
             }

             screen.setBrightness(Poten.read());

        wait(0.5);
        /*

            // these are default settings so not strictly needed
            lcd.normalMode();      // normal colour mode
            lcd.setBrightness(0.5); // put LED backlight on 50%

            // can directly print strings at specified co-ordinates
            lcd.printString("Hello, World!",0,0);

            char buffer[14];  // each character is 6 pixels wide, screen is 84 pixels (84/6 = 14)
            // so can display a string of a maximum 14 characters in length
            // or create formatted strings - ensure they aren't more than 14 characters long
            int temperature = 27;
            int length = sprintf(buffer,"T = %2d C",temperature); // print formatted data to buffer
            // it is important the format specifier ensures the length will fit in the buffer
            if (length <= 14)  // if string will fit on display
                lcd.printString(buffer,0,1);           // display on screen

            float pressure = 1012.3;  // same idea with floats
            length = sprintf(buffer,"P = %.2f mb",pressure);
            if (length <= 14)
                lcd.printString(buffer,0,2);

            // can also print individual characters at specified place
            lcd.printChar('X',5,3);

            // draw a line across the display at y = 40 pixels (origin top-left)
            for (int i = 0; i < WIDTH; i++) {
                lcd.setPixel(i,40);
            }
            // need to refresh display after setting pixels
            lcd.refresh();

            // can also check status of pixels using getPixel(x,y)

            wait(5.0);
            lcd.clear();            // clear display
            lcd.inverseMode();      // invert colours
            lcd.setBrightness(1.0); // put LED backlight on full

            float array[84];

            for (int i = 0; i < 84; i++) {
                array[i] = 0.5 + 0.5*sin(i*2*3.14/84);
            }

            // can also plot graphs - 84 elements only
            // values must be in range 0.0 - 1.0
            lcd.plotArray(array);
            wait(5.0);
            lcd.clear();
            lcd.normalMode();      // normal colour mode back
            lcd.setBrightness(0.5); // put LED backlight on 50%

            // example of drawing lines
            for (int x = 0; x < WIDTH ; x+=10) {
                // x0,y0,x1,y1,type 0-white,1-black,2-dotted
                lcd.drawLine(0,0,x,HEIGHT,2);
            }
            lcd.refresh();   // need to refresh screen after drawing lines

            wait(5.0);
            lcd.clear();

            // example of how to draw circles
            lcd.drawCircle(WIDTH/2,HEIGHT/2,20,1);  // x,y,radius,black fill
            lcd.drawCircle(WIDTH/2,HEIGHT/2,10,2);  // x,y,radius,white fill
            lcd.drawCircle(WIDTH/2,HEIGHT/2,30,0);  // x,y,radius,transparent with outline
            lcd.refresh();   // need to refresh screen after drawing circles

            wait(5.0);
            lcd.clear();

            // example of how to draw rectangles
            //          origin x,y,width,height,type
            lcd.drawRect(10,10,50,30,1);  // filled black rectangle
            lcd.drawRect(15,15,20,10,2);  // filled white rectange (no outline)
            lcd.drawRect(2,2,70,40,0);    // transparent, just outline
            lcd.refresh();   // need to refresh screen after drawing rects


            wait(5.0);
            lcd.clear();

            */
        //  Sleep();
        //wait(0.2);
        screen.clear();
        
        if (startReading)
        {
            startFlag = 0;
         }   
    }
        
        
        }
        
        
}

