#include "mbed.h"
#include "Rm3100.hpp"

int main(void)
{
    Serial pc(USBTX, USBRX);
    pc.baud(115200);

    printf("### Hello RM3100 ###\r\n");

    int addr = ((Rm3100::RM3100_ADDR | Rm3100::RM3100_ADDR_SSN) << 1);
    struct Rm3100::Status status = { 0 };
    struct Rm3100::Sample sample = { 0 };

    Rm3100 sensor(I2C_SDA, I2C_SCL, addr);

    sensor.Begin();
    osDelay(1);

    sensor.SetCycleCounts(200);
    osDelay(1);

    sensor.SetRate(100.0f);
    osDelay(1);

    sensor.SetContinuousMeasurementMode(true);
    osDelay(1);

    while (true) {
        sensor.GetStatus(&status);
        if (status.drdy) {
            sensor.GetSample(&sample);
            printf("x: %f, y: %f, z: %f\r\n", sample.x, sample.y, sample.z);
        }
        osDelay(10);
    }
}