#include "mbed.h"
// Programed by Seungchan Lee, futuremax7@gmail.com
// 2021.07.15

//Serial pc(USBTX, USBRX);
static UARTSerial pc(USBTX, USBRX, 115200);

InterruptIn drdy(D10); 
SPI ads1299(D11, D12, D13); // mosi, miso, sclk
DigitalOut cs(D9);
DigitalOut reset(A1);
DigitalOut pwdn(A2);
DigitalOut start(A0);

//SPI Command Definition Byte Assignments (Datasheet, p35)
#define _WAKEUP         0x02 // Wake-up from standby mode
#define _STANDBY        0x04 // Enter Standby mode
#define _RESET          0x06 // Reset the device
#define _START          0x08 // Start and restart (synchronize) conversions
#define _STOP           0x0A // Stop conversion
#define _RDATAC         0x10 // Enable Read Data Continuous mode (default mode at power-up)
#define _SDATAC         0x11 // Stop Read Data Continuous mode
#define _RDATA          0x12 // Read data by command; supports multiple read back

//Register Addresses
#define ID              0x00
#define CONFIG1         0x01
#define CONFIG2         0x02
#define CONFIG3         0x03
#define LOFF            0x04
#define CH1SET          0x05
#define CH2SET          0x06
#define CH3SET          0x07
#define CH4SET          0x08
#define CH5SET          0x09
#define CH6SET          0x0A
#define CH7SET          0x0B
#define CH8SET          0x0C
#define BIAS_SENSP      0x0D
#define BIAS_SENSN      0x0E
#define LOFF_SENSP      0x0F
#define LOFF_SENSN      0x10
#define LOFF_FLIP       0x11
#define LOFF_STATP      0x12
#define LOFF_STATN      0x13
#define GPIO            0x14
#define MISC1           0x15
#define MISC2           0x16
#define CONFIG4         0x17

#define REG_LENGTH          0x18
#define REG_UPPER_START     0x01
#define REG_UPPER_LENGTH    0x11
#define REG_LOWER_START     0x14
#define REG_LOWER_LENGTH    0x04

#define BYTE_DATA         28
#define BYTE_HEADER       2
#define BYTE_INFO         1
#define DATA_LENGTH       (BYTE_DATA+BYTE_HEADER+BYTE_INFO)

char ads1299_reg_data0[REG_LENGTH] = {0x3C, 0x96, 0xC0, 0x60, 0x00, 0x61, 0x61, 0x61, 0x61, 0x00, 0x00, 0x00, 0x00,
                                     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00};
char ads1299_reg_data1[REG_LENGTH] = {0x3C, 0x96, 0xD0, 0xFC, 0x00, 0x65, 0x65, 0x61, 0x60, 0x00, 0x00, 0x00, 0x00,
                                     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
char ads1299_reg_buf[REG_LENGTH]   = {0};

void ads1299_command(char command)
{
    cs = 0;
    ads1299.write(command);
    cs = 1;
    wait(0.01); // 100 ms
}

char ads1299_rreg(char address)
{
    char opcode1 = address + 0x20;        //  RREG expects 001rrrrr where rrrrr = _address
    cs = 0;                                  //  open SPI
    ads1299.write(opcode1);                  //  opcode1
    ads1299.write(0x00);                     //  opcode2
    ads1299_reg_buf[address] = ads1299.write(0x00);  //  update mirror location with returned byte
    cs = 1;                                     //  close SPI
    printf("RREG 0x%0X = 0x%0X\n", address, ads1299_reg_buf[address]);
    
    return ads1299_reg_buf[address];           // return requested register value
}

void ads1299_rregs()
{
    const char tx_buf[REG_LENGTH]={0};
    
    cs = 0;                                  //  open SPI
    ads1299.write(0x20);                     //  opcode1
    ads1299.write(REG_LENGTH-1);                     //  opcode2
    ads1299.write(tx_buf, REG_LENGTH, ads1299_reg_buf, REG_LENGTH);
    cs = 1;                                   //  close SPI
    for (char n = 0; n<REG_LENGTH; n++)
    {
        printf("RREG 0x%0X = 0x%0X\n", n, ads1299_reg_buf[n]);
    }
}

void ads1299_wreg(char address, char data)
{
    char opcode1 = address + 0x40;        //  RREG expects 001rrrrr where rrrrr = _address
    cs = 0;                                  //  open SPI
    ads1299.write(opcode1);                  //  opcode1
    ads1299.write(0x00);                     //  opcode2
    ads1299.write(data);                    //  update mirror location with returned byte
    cs = 1;                                     //  close SPI
    
//    char check = ads1299_rreg(address);
//    printf("WREG 0x%X = 0x%X\n", address, check);
}

void ads1299_wregs_upper(char* data)
{
    char rx_buf[REG_UPPER_LENGTH]={0};
    
    cs = 0;                                  //  open SPI
    ads1299.write(0x40+REG_UPPER_START);                     //  opcode1
    ads1299.write(REG_UPPER_LENGTH-1);                     //  opcode2
    ads1299.write(data+REG_UPPER_START, REG_UPPER_LENGTH, rx_buf, REG_UPPER_LENGTH);
    cs = 1;                                   //  close SPI
    
//    printf("WREG ALL check!\n");
//    ads1299_rregs();
}

void ads1299_wregs_lower(char* data)
{
    char rx_buf[REG_LOWER_LENGTH]={0};
    
    cs = 0;                                  //  open SPI
    ads1299.write(0x40+REG_LOWER_START);                     //  opcode1
    ads1299.write(REG_LOWER_LENGTH-1);                     //  opcode2
    ads1299.write(data+REG_LOWER_START, REG_LOWER_LENGTH, rx_buf, REG_LOWER_LENGTH);
    cs = 1;                                   //  close SPI
    
//    printf("WREG ALL check!\n");
//    ads1299_rregs();
}

//-------------------------------------------------------------------------------------------------------

int main() {
//    pc.baud(115200);
    
    // GPIO setting
    reset = 1;
    pwdn = 1;
    start = 0;    
    cs = 1;
 
    // Setup the ads1299 for 8 bit data, high steady state clock,
    // second edge capture, with a 1MHz clock rate
    ads1299.format(8,1);
    ads1299.frequency(10000000);
    wait(0.1);
 
    cs = 0;
    ads1299.write(0x06); //RESET
    cs = 1;
    wait(0.5); // 100 ms
    
    cs = 0;
    ads1299.write(0x11); //SDATAC
    cs = 1;
    wait(0.1); // 100 ms
    
    while(1)
    {
        ads1299_rreg(0x05);
        wait(0.1);
        ads1299_wreg(0x05, 0x62);
        printf("reg 0x05 modified to 0x62\n"); 
        wait(0.1);
        
        ads1299_rreg(0x05);
        wait(0.1);
        ads1299_wreg(0x05, 0x61);
        printf("reg 0x05 modified to 0x61\n"); 
        wait(0.1);
    }
}