

extern void Button_Init (void);
extern void StartHP (void);
extern void StopHP (void const *n);
extern DigitalOut hp(PTB9);
extern KW40Z kw40z_device(PTE24, PTE25);
extern RtosTimer hpTime(StopHP, osTimerOnce);
extern int but;

void StartHP (void);
void StopHP (void const *n);

int but = 1;

//Buttons-------------------------------

void ButtonUp(void) 
{
    StartHP();
}

void ButtonDown(void) 
{
    StartHP();
    but = 0;
}

void ButtonRight(void) 
{
    StartHP();
    but = 1;
}

void ButtonLeft(void) 
{
    StartHP();
    but = 2;
}

void ButtonSlide(void) 
{
    StartHP();
}

void Button_Init (void)
{
    kw40z_device.attach_buttonUp(&ButtonUp);
    kw40z_device.attach_buttonDown(&ButtonDown);
    kw40z_device.attach_buttonLeft(&ButtonLeft);
    kw40z_device.attach_buttonRight(&ButtonRight);
}

//Haptic -----------------------------------------

void StartHP(void)
{
    hpTime.start(50);
    hp = 1;
}

void StopHP(void const *n)
{
    hp = 0;
    hpTime.stop();
}