//Filarius Peter Usop
//Mini Project 1
//Uses LEDs, Buttons, Haptic, and OLEd

#include "mbed.h"
#include "Hexi_OLED_SSD1351.h"
#include "Hexi_KW40Z.h"
#include "Functions.h"
#include "string.h"

//SSD1351 Driver (OLED) Instantiation
SSD1351 oled(PTB22, PTB21, PTC13, PTB20, PTE6, PTD15);

Timer t;

int main (void)
{
    //Initialize buttons
    Button_Init();
    
    //Initialize the text properties to default
    oled_text_properties_t textProp = {0};
    oled.GetTextProperties(&textProp);

    //String Pointer
    char text[20];
    
    //Flag
    int flag = 1;

    //Clear screen
    oled.DrawBox(0,0,96,96,COLOR_BLACK);
    
    //Top Title
    strcpy((char *) text, "Stopwatch");
    textProp.fontColor = COLOR_WHITE;
    textProp.alignParam = OLED_TEXT_ALIGN_CENTER;
    oled.SetTextProperties(&textProp);
    oled.TextBox((const uint8_t *) text,0,0,96,15);
    
    textProp.fontColor = COLOR_RED;
    oled.SetTextProperties(&textProp);
    
    t.start();  //Start stopwatch. You may remove this line
    
    //Print to OLED
    sprintf(text, "%.0f", t.read());
    oled.TextBox((uint8_t *) text,0,40,96,15);
    
    while (1) {
        Thread::wait(1000);         //Refresh every 1 second
        if (flag == 1)      //Down button: Stops and resets the stopwatch
        {
            t.stop();
            t.reset();
            sprintf(text, "%.0f", t.read());
            flag++;
        }
        else if (flag == 2) //Right button: Starts the stopwatch
        {
            if (but == 1)
            {
                t.start();
                flag++;
            }
            else if (but == 0) flag--;
        }
        else if (flag == 3) //Left button: Stops the stopwatch
        {
            if (but == 2)
            {
                t.stop();
                flag--;
            }
            else if (but == 0) flag = flag-2;
        }
                
        //Update value on OLED
        sprintf(text, "%.0f", t.read());
        oled.TextBox((uint8_t *) text,0,40,96,15);
    }
}
