//------------------------------------------------------------------------------
//                      PAGES FUNCTION DEFINITIONS
//------------------------------------------------------------------------------

void TimeSetup() 
{
    //Variables
    int point = 1;  //Points to which digit
    int valid = 0;  //Exit confirmation
    int num = 0;    //Temporary number holder
    int xc = 25;    //Initial cursor's x-position
    
    //Screen Setup
    oled.FillScreen(COLOR_BLACK);
    
    strcpy((char *) str, "Set time and date");
    oled.Label((uint8_t *) str, 0, 0);

    strcpy((char *) str, "HH:MM");
    oled.Label((uint8_t *) str, 30, 20);
    
    strcpy((char *) str, "Hours");
    oled.Label((uint8_t *) str, 2, 80);
    
    strcpy((char *) str, "Mins/OK");
    oled.Label((uint8_t *) str, 43, 80);
    
    while (valid != 1)  //This is a loop for time input
    {
        if (butflg == 1)
        {
            if (butmem == BUT_RIGHT && point == 1)  //Go right to minutes
            {
                hours = num;
                num = mins;
                point = 2;
                xc = 45;
            }
            else if (butmem == BUT_RIGHT && point == 2 && valid == 0) //Exit
            {
                mins = num;
                valid = 1;
            }
            else if (butmem == BUT_LEFT && point == 2 && valid == 0) //Go left to seconds
            {
                mins = num;
                num = hours;
                point = 1;
                xc = 25;
            }
            
            //Increases the number of the hours/minutes using the up or down button
            if (butmem == BUT_UP && ((point == 1 && num != 23) || (point == 2 && num != 59))) num++;
            else if (butmem == BUT_DOWN && num != 0) num--;
            butflg = 0;
        }
        
        //Updates the display
        sprintf((char *) str, "%d", num);
        oled.TextBox((uint8_t *) str, xc, 40, 15, 15);
        Thread::wait(500);
    }
    
    numCount = 0;   //Activate the time flag
}

void TimeDisplay() 
{
    sprintf((char *) str, "%.2d : %.2d", hours, mins);
    oled.Label((uint8_t *) str, 30, 0);
}

void MainDisp() 
{
    //This is the home screen    
    strcpy((char *) str, "Delete");
    oled.Label((uint8_t *) str, 5, 80);
    
    strcpy((char *) str, "Add");
    oled.Label((uint8_t *) str, 60, 80);   
}

void ReminderList()
{
    int m;
    //For the other two buttons
    if (nDisp == 5) 
    {
        oled.DrawBox(0, 30, 96, 96-30-15, COLOR_BLACK);
        strcpy((char *) str, "No Data");
        oled.Label((uint8_t *) str, 10, 45);
    }
    else
    { 
        if (butmem == BUT_UP)
        {
            for (m = nDisp+1; m < 5; m++)
            {
                if (remData[m].rExist == 1) 
                {
                    nDisp = m;
                    break;
                }
            }
        }
        else if (butmem == BUT_DOWN)
        {
            for (m = nDisp-1; m >= 0; m--)
            {
                if (remData[m].rExist == 1) 
                {
                    nDisp = m;
                    break;
                }
            }
        }
        
        //Display the result
        oled.DrawBox(0, 30, 96, 96-30-15, COLOR_BLACK);
        oled.Label((uint8_t *) remData[nDisp].rText, 10, 40);
        sprintf((char *) str, "    %d:%d", remData[nDisp].rHours, remData[nDisp].rMins);
        oled.Label((uint8_t *) str, 20, 55);
    }
}

void AddReminder() 
{    
    //Temporary Variable for Input Acknowledgement
    int inputAck = 0;
    int xc = 25;
    int num = 0;
    int total = 0;
    
    //Clear Screen
    oled.DrawBox(0, 30, 96, 96-30, COLOR_BLACK);
    
    //Count how many reminders are in there
    //For now, limit to 5 data
    for (num = 0; num < 5; num++) total = total+remData[num].rExist;
    
    //Since num is used in the time input code block, clear it
    num = 0;
    
    if (total == 5)   
    {
        strcpy((char *) str, "Reminder Full");
        oled.Label((uint8_t *) str, 10, 45);
        
        DelayProg(6);
    }
    else    //Here is the main program for AddReminder()
    {
        //First we offset to the first entry with rExist = 0;
        
        for (rNumber = 0; rNumber < 5; rNumber++)
        {
            if (remData[rNumber].rExist == 0) break;
        }
        
        //Then we display whatever we need to display
        
        //Display Entry Number
        sprintf((char *) str, "Entry #%d", rNumber+1);
        oled.Label((uint8_t *) str, 0, 30);
        
        //Text Input---------------------------------------------
        strcpy((char *) str, "Agenda:");
        oled.Label((uint8_t *) str, 0, 45);
                        
        inputAck = CharInput(60, rNumber);
        //DelayProg(6);
        
        oled.DrawBox(0, 45, 96, 96-45, COLOR_BLACK);
        
        if (inputAck == 0)
        {
            oled.DrawBox(0, 30, 96, 96-30, COLOR_BLACK);
            
            strcpy((char *) str, "Canceled");
            oled.Label((uint8_t *) str, 0, 45);
            
            DelayProg(6);
            
            //Break the hell out of this function.
            goto AddRemExit;
        }
        
        //Else, proceed to time input
        
        //Time input----------------------------------------------
        strcpy((char *) str, "Time(HH:MM):");
        oled.Label((uint8_t *) str, 0, 30);
        
        strcpy((char *) str, "Hours");
        oled.Label((uint8_t *) str, 2, 80);
        
        strcpy((char *) str, "Mins/OK");
        oled.Label((uint8_t *) str, 43, 80);
        
        //Breakdown of the variables
        //  xc = x-position, as well as the reference of hours or minutes
        //  inputAck 
        //  num = temporary variable
        
        while (1)  //This is a time input loop for reminders
        {
            if (butflg == 1)
            {
                if (butmem == BUT_RIGHT && xc == 25)    //Go right to minutes
                {
                    remData[rNumber].rHours = num;    //num is recycled from previous functions
                    num = remData[rNumber].rMins;
                    xc = 45;
                }
                else if (butmem == BUT_LEFT && xc == 25)        //Exit  (Cancelled)
                {
                    remData[rNumber].rHours = 0;
                    remData[rNumber].rMins = 0;
                    strcpy(remData[rNumber].rText, "         ");
                    inputAck = 0;
                    break;      //Don't forget this is the second 'if loop'.
                }                    
                else if (butmem == BUT_RIGHT && xc == 45)       //Exit  (Confirmed)
                {
                    remData[rNumber].rMins = num;
                    inputAck = 1;
                    break;      //Don't forget this is the second 'if loop'.
                }
                else if (butmem == BUT_LEFT && xc == 45) //Go left to seconds
                {
                    remData[rNumber].rMins = num;
                    num = remData[rNumber].rHours;
                    xc = 25;
                }
                
                //Increases the number of the hours/minutes using the up or down button
                if (butmem == BUT_UP && ((xc == 25 && num != 23) || (xc == 45 && num != 59))) num++;
                else if (butmem == BUT_DOWN && num != 0) num--;
                butflg = 0;
            }
            
            if (inputAck == 0) goto AddRemExit;    //And this continues from the Exit (Cancelled)
            
            //Updates the display
            sprintf((char *) str, "%d", num);
            oled.TextBox((uint8_t *) str, xc, 60, 15, 15);
        }
        
        if (inputAck == 0)
        {
            oled.DrawBox(0, 30, 96, 96-30, COLOR_BLACK);
            strcpy((char *) str, "Canceled");
            oled.Label((uint8_t *) str, 0, 45);
            
            DelayProg(6);
            
            //Break the hell out of this function.
            goto AddRemExit;
        }
        
        //All the details are confirmed ----------------------------------------
        
        remData[rNumber].rExist = 1;       
        
        oled.DrawBox(0, 30, 96, 96-30, COLOR_BLACK);
        strcpy((char *) str, "Reminder Added");
        oled.Label((uint8_t *) str, 0, 45);   
        
        DelayProg(6);       
    } 
    
AddRemExit:  
    
    //Setup Screen before exiting    
    oled.DrawBox(0, 30, 96, 96-30, COLOR_BLACK);   
    MainDisp();
    
    //Set this flag to 1 to recalculate the display data
    fReCalc = 1;
}

void DelReminder() 
{
    int n;
    int total = 0;
    
    //Clear Screen
    oled.DrawBox(0, 30, 96, 96-30, COLOR_BLACK);
    
    //If total is 0, then there is no data to delete, ain't it?
    for (n = 0; n < 5; n++) total = total+remData[n].rExist;
    
    if (total == 0)
    {
            strcpy((char *) str, "No Data");
            oled.Label((uint8_t *) str, 10, 45);
            
            DelayProg(6);
    }
    else        //Case when there is a Data to delete
    {
        //First we must offset to the first existing data
        for (n = 0; n < 5; n++) 
        {
            if (remData[n].rExist != 0) break;
        }
        
        //Then we display whatever we need to display
                
        //We enter the navigation
        
        butmem = 0;
        
        //First thing that it should display
        
        sprintf((char *) str, "Entry #%d", n+1);    //Entry Number
        oled.Label((uint8_t *) str, 0, 30);
        oled.Label((uint8_t *) remData[n].rText, 0, 45);    //Its text
        sprintf((char *) str, "%d:%d", remData[n].rHours, remData[n].rMins);     //Its time, for SPARTAAAAAAA
        
        while (1)       //NOTE: THIS IS TERRIBLY RISKY, BUT whatever
        {
            if (butflg == 1)
            {
                //There are two parts in this section
                
                //FIRST PART: DO I GO NEXT OR PREVIOUS?
                if (butmem == BUT_UP)
                {
                    //Let's recycle total here. total is used as pointer
                    //So if there is any data after the value n, we can move up
                    for (total = n+1; total < 5; total++)
                    {
                        if (remData[total].rExist != 0) break;
                    }
                    
                    if (total != 5) n = total;
                    total = 0;      //For various reasons, reset total
                }
                else if (butmem == BUT_DOWN)
                {
                    //Let's...you know what I'm gonna talk about
                    for (total = n-1; total >= 0; total--)
                    {
                        if (remData[total].rExist != 0) break;
                    }
                    
                    if (total != -1) n = total;
                    total = 0;      //For the same reason as above, reset total
                }
                
                //SECOND PART: DO I WANT TO DELETE OR NAH
                if (butmem == BUT_LEFT) total = 0x11;       //Uh, reasons
                else if (butmem == BUT_RIGHT) total = 0x27; //Fav Number
                //*That is why I need to reset total everytime*
                
                //THIRD PART(DID YOU NOT EXPECT THE SPANISH INQUISITION?)
                //Display the stuff
                
                oled.DrawBox(0, 30, 96, 96-30, COLOR_BLACK);
                sprintf((char *) str, "Entry #%d", n+1);    //Entry Number
                oled.Label((uint8_t *) str, 0, 30);                            
                oled.Label((uint8_t *) remData[n].rText, 0, 45);
                sprintf((char *) str, "%d:%d", remData[n].rHours, remData[n].rMins);
                oled.Label((uint8_t *) str, 0, 60);

                butflg = 0;
            }
            
            //Delete Data and Exit
            if (total == 0x27)
            {
                strcpy(remData[n].rText, "          ");
                remData[n].rHours = 0;
                remData[n].rMins = 0;
                remData[n].rExist = 0;
                
                oled.DrawBox(0, 30, 96, 96-30, COLOR_BLACK);
                oled.DrawBox(0, 30, 96, 96-30, COLOR_BLACK);
                
                sprintf((char *) str, "Entry #%d Deleted", n+1);
                oled.Label((uint8_t *) str, 0, 45);
                
                DelayProg(6);
                
                break;
            }
            //Exit this function
            else if (total == 0x11) break; 
                    
        }//End of While Loop
  
    }//End of Else Loop
    
    //Setup Screen before exiting
    oled.DrawBox(0, 30, 96, 96-30, COLOR_BLACK);          
    MainDisp();
    
    //Set this flag to 1 to recalculate the display data
    fReCalc = 1;
    
}//End of GOSH HOW CAN YOU NOT KNOW WHAT END IS THIS?
    