
//------------------------------------------------------------------------------
//                          FUNCTION PROTOTYPES
//------------------------------------------------------------------------------

//Pages
void TimeSetup (void);
void TimeDisplay (void);
void ReminderList (void);
void AddReminder (void);
void DelReminder (void);
void MainDisp (void);

//Interrupt
void InterruptAction (void const *n);

//Buttons
void BU(void);
void BD(void);
void BL(void);
void BR(void);
void BS(void);
void B_attach(void);
void B_response(int);

//Supplementary
int CharInput (int, int);
void DelayProg (int);
void TextInit (void);

//------------------------------------------------------------------------------
//                      GLOBAL VARIABLE DEFINITIONS
//------------------------------------------------------------------------------

//Vibration pin
DigitalOut vib(PTB9);

//Debugging LEDs
DigitalOut red(LED1);
DigitalOut green(LED2);
DigitalOut blue(LED3);

//Timer
RtosTimer masa(InterruptAction, osTimerOnce);   //Keep it this way (non-periodic). 
                                                //Who knows you want to stop the 
                                                //interrupt for some reason
                                                
//Buttons
KW40Z butt(PTE24, PTE25);                       //UART TX, UART RX

//Buzzer
PwmOut buzz(PTA10);

/* Instantiate the SSD1351 OLED Driver */ 
SSD1351 oled(PTB22,PTB21,PTC13,PTB20,PTE6,PTD15); /*(MOSI,SCLK,POWER,CS,RST,DC)*/
oled_text_properties_t tProp = {0};

//Buzzer at 1st Peripheral Position
PwmOut Buzzer(PTA10);    
                                                
//Variables
char str[20];

int butmem = 0;

int numCount = -1;
int vibCount = 0;
int hours = 0;
int mins = 0;
int secs = 0;

int fReCalc = 0;
int nDisp = 5;

//Alarm parameters
int nAlarm = 0;     //Entry pointer
int fAlarm = 0;     //Alarm flag
int vAlarm = 0;     //Vibration period

//For certain delays in the program 
double delay = 0;
int dummy = 0;

//Interrupt Flags
int butflg = 0;
int vibflg = 0;
int delayflg = 0;

//Sound Flags
int WSound = 0;
int CCSound = 0;
int SCSound = 0;
int DLSound = 0;

//Reminder Variables
typedef struct reminderProperties
{
    char rText[11];     //The text of the reminder
    int rExist;         //Indicates whether the reminder exists or not
    int rMins;          //Time of the reminder
    int rHours;
} remProp;

int rNumber = 0;        //How many reminders exist?

remProp remData[5];

//Buttons Mnemonic
enum button_number {
    BUT_UP = 1,
    BUT_DOWN = 2,
    BUT_LEFT = 3,
    BUT_RIGHT = 4
} butnum;

//Texts
char remTxt[6][11];
//Refer to Texts Initialization Function

//Buzzer
float    C3 = 1000000/Do3,
        Cs3 = 1000000/Do3s,
         D3 = 1000000/Re3,
        Ds3 = 1000000/Re3s,
         E3 = 1000000/Mi3,
         F3 = 1000000/Fa3,
        Fs3 = 1000000/Fa3s,
         G3 = 1000000/So3,
        Gs3 = 1000000/So3s,
         A3 = 1000000/La3,
        As3 = 1000000/La3s,
         B3 = 1000000/Ti3,
         C4 = 1000000/Do4,
        Cs4 = 1000000/Do4s,
         D4 = 1000000/Re4,
        Ds4 = 1000000/Re4s,
         E4 = 1000000/Mi4,
         F4 = 1000000/Fa4,
        Fs4 = 1000000/Fa4s,
         G4 = 1000000/So4,
        Gs4 = 1000000/So4s,
         A4 = 1000000/La4,
        As4 = 1000000/La4s,
         B4 = 1000000/Ti4,
         C5 = 1000000/Do5,
        Cs5 = 1000000/Do5s,
         D5 = 1000000/Re5,
        Ds5 = 1000000/Re5s,
         E5 = 1000000/Mi5,
         F5 = 1000000/Fa5,
        Fs5 = 1000000/Fa5s,
         G5 = 1000000/So5,
        Gs5 = 1000000/So5s,
         A5 = 1000000/La5,
        As5 = 1000000/La5s,
         B5 = 1000000/Ti5;