
//------------------------------------------------------------------------------
//                            MAIN PROGRAM
//------------------------------------------------------------------------------
//Main program controls the navigation of menus
//------------------------------------------------------------------------------

int main (void)
{
    //Miscellanous Variables used for this function
    int n;
    
    //--------------------------------------------------------------------------
    //                          INITIALIZATIONS
    //--------------------------------------------------------------------------

    //Attach Buttons Callback Functions
    B_attach();
    
    //Text Formatting in OLED
    oled.GetTextProperties(&tProp);
    oled.DimScreenOFF();
    oled.FillScreen(COLOR_BLACK);
    tProp.fontColor = COLOR_WHITE;
    tProp.alignParam = OLED_TEXT_ALIGN_CENTER;
    oled.SetTextProperties(&tProp);
    
    //Flush all the reminder data for now.
    for (n = 0; n < 5; n++) 
    {
        remData[n].rExist = 0;
        remData[n].rMins = 0;
        remData[n].rHours = 0;
    }
    
    //Initializations of Strings
    TextInit();
    
    //INTERRUPT STARTS HERE
    masa.start(1); //In miliseconds
    
    
    //--------------------------------------------------------------------------
    //                          MENU SELECTION
    //--------------------------------------------------------------------------
    
    TimeSetup();
    oled.FillScreen(COLOR_BLACK);
    
    TimeDisplay();      //Just display time for now
    MainDisp();         //Setup the home screen for the first time

    ReminderList();    //Setup the data list display for the first time     
    
    //Program Loop in here
    while(1) 
    {       
        //Go into AddReminder() if the user enters Right
        if (butflg == 1)
        {
            if (butmem == BUT_RIGHT) AddReminder();
            else if (butmem == BUT_LEFT) DelReminder();
            
            //At the end of either functions, reset the screen to home screen, with first available
            //data to display
            if (fReCalc == 1 || fAlarm == 2)            
            {
                for (nDisp = 0; nDisp < 5; nDisp++)
                {
                    if (remData[nDisp].rExist == 1) break;
                }
                fReCalc = 0;            //This solved the mystery
            }
            
            //Update the list in the display
            ReminderList();
            
            //Prevent loop reentry
            butflg = 0;
        }
    }
}