
//------------------------------------------------------------------------------
//                          INTERRUPT ROUTINE
//------------------------------------------------------------------------------

void InterruptAction (void const *n)
{    
    int num = 0;
    //--------------------------------------------------------------------------
    //                           TIME UPDATE
    //--------------------------------------------------------------------------
    if (numCount != -1)
    {
        if (numCount == 1000)
        {
            //Time increment Section--------------------------------------------
            numCount = 0;
            //Check for Seconds
            if (secs == 59)
            {
                secs = 0;
                //Check for Minutes
                if (mins == 59)
                {
                    mins = 0;
                    //Check for Hours
                    if (hours == 23) hours = 0;
                    else hours++;
                }
                else 
                {
                    mins++;
                    TimeDisplay();  //Update time every minute
                }                   //Always display time on all pages
            }
            else secs++;
            
            //Alarm Section-----------------------------------------------------
            //Assuming the CPU can do this really really fast, I hope it won't affect
            //the overall performance of the program
            for (num = 0; num < 5; num++)
            {
                if (remData[num].rExist == 1)
                {
                    if (remData[num].rHours == hours && remData[num].rMins == mins)
                    {
                        fAlarm = 1;
                        nAlarm = num;
                        num = 5;      //Just to exit the loop
                    }
                }
            }           
        }
        else numCount++;
    }
    
    //--------------------------------------------------------------------------
    //                        ALERT DISPLAY FEEDBACK
    //--------------------------------------------------------------------------
    
    if (fAlarm == 1)        //1st Stage: Display
    {
        oled.Label((uint8_t *) remData[nAlarm].rText, 10, 15);
        
        //Wipe the data from memmory
        strcpy(remData[nAlarm].rText, "          ");
        remData[nAlarm].rHours = 0;
        remData[nAlarm].rMins = 0;
        remData[nAlarm].rExist = 0;
        
        //Preparation for the next stage
        fAlarm = 2;
        nAlarm = 10000;     //Set to 10 seconds display
        vAlarm = 5000;      //Set to 5 seconds vibration
        
        //Start the mayhem:
        vibflg = 1;
        vib = 1;
    }
    else if (fAlarm == 2)   //2nd Stage: Hold
    {
        nAlarm--;
        if (nAlarm == 0)
        {
            oled.DrawBox(0, 15, 96, 15, COLOR_BLACK);  //Clear Area
            fAlarm = 0;     //Reset Parameters
            nAlarm = 0;   
        }
    }

    //--------------------------------------------------------------------------
    //                      VIBRATION HAPTIC FEEDBACK
    //--------------------------------------------------------------------------
    if (vibflg == 1)
    {
        if (vAlarm == 0)    //Prevent overlapping functions with the above vibration function
        {
            vib = 1;
            vibCount++;
            if (vibCount == 100)
            {
                vibflg = 0;
                vib = 0;
                vibCount = 0;
            }
        }
        else                //Just to supress additional vibration
        {
            vAlarm--;
            if (vAlarm == 0)
            {
                vibflg = 0;
                vib = 0;
                vibCount = 0;
            }
        }
    }
    
    masa.start(1);
} 